/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.tree;

import junit.framework.Assert;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.swing.tree.TreeNodeExistenceResolver;
import org.robotframework.swing.tree.TreeSupport;

@RobotKeywords
public class TreeNodeExistenceKeywords
extends TreeSupport {
    public static final String __PARANAMER_DATA = "\ntreeNodeShouldExist java.lang.String,java.lang.String identifier,nodeIdentifier \n\ntreeNodeShouldNotExist java.lang.String,java.lang.String identifier,nodeIdentifier \n";

    @RobotKeyword(value="Fails if the tree node does not exist.\n\nExample:\n| Tree Node Should Exist | _myTree_ | _Root|Folder_ |\n")
    public void treeNodeShouldExist(String identifier, String nodeIdentifier) {
        boolean treeNodeExists = this.createExistenceResolver(identifier).treeNodeExists(nodeIdentifier);
        Assert.assertTrue((String)("Tree node '" + nodeIdentifier + "' doesn't exist."), (boolean)treeNodeExists);
    }

    @RobotKeyword(value="Fails if the tree node exists.\n\nExample:\n| Tree Node Should Not Exist | _myTree_ | _Root|Folder_ |\n")
    public void treeNodeShouldNotExist(String identifier, String nodeIdentifier) {
        boolean treeNodeExists = this.createExistenceResolver(identifier).treeNodeExists(nodeIdentifier);
        Assert.assertFalse((String)("Tree node '" + nodeIdentifier + "' exists."), (boolean)treeNodeExists);
    }

    TreeNodeExistenceResolver createExistenceResolver(String treeIdentifier) {
        return new TreeNodeExistenceResolver(this.createTreeOperator(treeIdentifier));
    }
}

