/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.tree;

import junit.framework.Assert;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.swing.tree.TreeSupport;

@RobotKeywords
public class TreeNodeKeywords
extends TreeSupport {
    public static final String __PARANAMER_DATA = "\ngetTreeNodeCount java.lang.String identifier \n\nclearTreeSelection java.lang.String identifier \n\ncollapseTreeNode java.lang.String,java.lang.String identifier,nodeIdentifier \n\nexpandTreeNode java.lang.String,java.lang.String identifier,nodeIdentifier \n\nselectTreeNode java.lang.String,java.lang.String identifier,nodeIdentifier \n\ntreeNodeShouldBeCollapsed java.lang.String,java.lang.String identifier,nodeIdentifier \n\ntreeNodeShouldBeExpanded java.lang.String,java.lang.String identifier,nodeIdentifier \n\ntreeNodeShouldBeLeaf java.lang.String,java.lang.String identifier,nodeIdentifier \n\ntreeNodeShouldNotBeLeaf java.lang.String,java.lang.String identifier,nodeIdentifier \n\nunselectTreeNode java.lang.String,java.lang.String identifier,nodeIdentifier \n";

    @RobotKeyword(value="Clears selections from a tree.\n\nExample:\n| Clear Tree Selection | _myTree_ |\n")
    public void clearTreeSelection(String identifier) {
        this.createTreeOperator(identifier).clearSelection();
    }

    @RobotKeyword(value="Collapses a node in a tree.\n\nExamples:\n| Collapse Tree Node | _myTree_ | _Root|Folder_ |\n| Collapse Tree Node | _myTree_ | _3_ |\n")
    public void collapseTreeNode(String identifier, String nodeIdentifier) {
        this.createTreeOperator(identifier).collapse(nodeIdentifier);
    }

    @RobotKeyword(value="Expands a node in a tree.\n\nExamples:\n| Expand Tree Node | _myTree_ | _Root|Folder_ |\n| Expand Tree Node | _myTree_ | _3_ |\n")
    public void expandTreeNode(String identifier, String nodeIdentifier) {
        this.createTreeOperator(identifier).expand(nodeIdentifier);
    }

    @RobotKeyword(value="Sets a node as selected in a tree.\nDoes not clear earlier selections.\n\nExample:\n| Select Tree Node | _myTree_ | _Root|Folder_ |\n")
    public void selectTreeNode(String identifier, String nodeIdentifier) {
        this.createTreeOperator(identifier).addSelection(nodeIdentifier);
    }

    @RobotKeyword(value="Fails if the tree node is collapsed.\n\nExample:\n| Tree Node Should Be Expanded | _myTree_ | _Root|Folder_ |\n")
    public void treeNodeShouldBeExpanded(String identifier, String nodeIdentifier) {
        boolean isExpanded = this.createTreeOperator(identifier).isExpanded(nodeIdentifier);
        Assert.assertTrue((String)("Tree node '" + nodeIdentifier + "' is not expanded."), (boolean)isExpanded);
    }

    @RobotKeyword(value="Fails if the tree node is expanded.\n\nExample:\n| Tree Node Should Be Collapsed | _myTree_ | _Root|Folder_ |\n")
    public void treeNodeShouldBeCollapsed(String identifier, String nodeIdentifier) {
        boolean isCollapsed = this.createTreeOperator(identifier).isCollapsed(nodeIdentifier);
        Assert.assertTrue((String)("Tree node '" + nodeIdentifier + "' is not collapsed."), (boolean)isCollapsed);
    }

    @RobotKeyword(value="Sets a tree node as unselected.\n\nExample:\n| Unselect Tree Node | _myTree_ | _Root|Folder_ |\n")
    public void unselectTreeNode(String identifier, String nodeIdentifier) {
        this.createTreeOperator(identifier).removeSelection(nodeIdentifier);
    }

    @RobotKeyword(value="Fails if the node has child nodes.\nAssumes current context is a tree.\nYou might want to set the waiting timeout with the keyword `Set Jemmy Timeout`\n\nExample:\n| Tree Node Should Be Leaf | _myTree_ | _Root|Folder_ |")
    public void treeNodeShouldBeLeaf(String identifier, String nodeIdentifier) {
        boolean isLeaf = this.createTreeOperator(identifier).isLeaf(nodeIdentifier);
        Assert.assertTrue((String)("Tree node '" + nodeIdentifier + "' is not leaf."), (boolean)isLeaf);
    }

    @RobotKeyword(value="Fails if the node doesn't have child nodes.\nYou might want to set the waiting timeout with the keyword `Set Jemmy Timeout`\n\nExample:\n| Tree Node Should Not Be Leaf | _myTree_ | _Root|Folder_ |")
    public void treeNodeShouldNotBeLeaf(String identifier, String nodeIdentifier) {
        boolean isLeaf = this.createTreeOperator(identifier).isLeaf(nodeIdentifier);
        Assert.assertFalse((String)("Tree node '" + nodeIdentifier + "' is leaf."), (boolean)isLeaf);
    }

    @RobotKeyword(value="Returns the count of all visible nodes.\n\nExample:\n| ${nodeCount} | Get Tree Node Count | _myTree_ || Should Be Equal As Integers | _3_ | _${nodeCount}_ |")
    public int getTreeNodeCount(String identifier) {
        return this.createTreeOperator(identifier).getRowCount();
    }
}

