/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.tree;

import junit.framework.Assert;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.swing.tree.TreeSupport;

@RobotKeywords
public class TreeNodeVisibilityKeywords
extends TreeSupport {
    public static final String __PARANAMER_DATA = "\ntreeNodeShouldBeVisible java.lang.String,java.lang.String identifier,nodePath \n\ntreeNodeShouldNotBeVisible java.lang.String,java.lang.String identifier,nodePath \n";

    @RobotKeyword(value="Fails if the tree node is not visible.\n\nExample:\n| Tree Node Should Be Visible | _myTree_ | _Root|Folder_ |\n")
    public void treeNodeShouldBeVisible(String identifier, String nodePath) {
        Assert.assertTrue((String)("Tree node '" + nodePath + "' is not visible."), (boolean)this.isVisible(identifier, nodePath));
    }

    @RobotKeyword(value="Fails if the tree node is visible.\n\nExample:\n| Tree Node Should Not Be Visible | _myTree_ | _Root|Folder_ |\n")
    public void treeNodeShouldNotBeVisible(String identifier, String nodePath) {
        Assert.assertFalse((String)("Tree node '" + nodePath + "' is visible."), (boolean)this.isVisible(identifier, nodePath));
    }

    private boolean isVisible(String identifier, String nodePath) {
        this.verifyPath(nodePath);
        return this.createTreeOperator(identifier).isVisible(nodePath);
    }

    private void verifyPath(String nodePath) {
        if (this.isIndex(nodePath)) {
            throw new IllegalArgumentException("Node's visibility cannot be checked by it's index.");
        }
    }
}

