/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.window;

import java.awt.Window;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JFrameOperator;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.swing.context.Context;
import org.robotframework.swing.context.ContextVerifier;
import org.robotframework.swing.factory.IdentifierParsingOperatorFactory;
import org.robotframework.swing.keyword.window.JFrameOperatorFactory;

@RobotKeywords
public class WindowKeywords
extends ContextVerifier {
    public static final String __PARANAMER_DATA = "\n<init> \n\ngetSelectedWindowTitle \n\ncloseWindow java.lang.String identifier \n\nselectMainWindow \n\nselectWindow java.lang.String identifier \n";
    private IdentifierParsingOperatorFactory<JFrameOperator> operatorFactory = new JFrameOperatorFactory();

    public WindowKeywords() {
        super("To use this keyword you must first select a window as context using the 'Select Window'-keyword.");
    }

    @RobotKeyword(value="Selects the window that was opened first as current context.\n\nExample:\n| Select Main Window |\n")
    public void selectMainWindow() {
        Context.setContext((ContainerOperator)this.operatorFactory.createOperatorByIndex(0));
    }

    @RobotKeyword(value="Selects a window was as current context.\n\nExample:\n| Select Window | _Help_ |\n")
    public void selectWindow(String identifier) {
        Context.setContext((ContainerOperator)this.operatorFactory.createOperator(identifier));
    }

    @RobotKeyword(value="Closes a window.\n\nExample:\n| Close Window | _Help_ |\n")
    public void closeWindow(String identifier) {
        JFrameOperator frameOperator = this.operatorFactory.createOperator(identifier);
        frameOperator.setDefaultCloseOperation(2);
        frameOperator.close();
    }

    @RobotKeyword(value="Returns the title of the selected window.\nAssumes current context is window.\n\nExample:\n| ${title}=     | Get Selected Window Title |            |\n| Should Be Equal | _Help Contents_           | _${title}_ |\n")
    public String getSelectedWindowTitle() {
        return this.frameOperator().getTitle();
    }

    protected Class[] getExpectedClasses() {
        return new Class[]{Window.class};
    }

    private JFrameOperator frameOperator() {
        this.verifyContext();
        return (JFrameOperator)Context.getContext();
    }
}

