/*
 * Decompiled with CFR 0.152.
 */
package abbot.editor.widgets;

import abbot.editor.widgets.SpinningDial;
import abbot.editor.widgets.WaitIndicator;
import abbot.util.AWT;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.Timer;

public class SpinningDialWaitIndicator
extends WaitIndicator
implements ActionListener {
    private static final int MAX_SIZE = 64;
    private static final int FADE_INTERVAL = 41;
    private static final int FADE_THRESHOLD = 192;
    private static final int MARGIN = 8;
    private static final int MARGIN_FRACTION = 8;
    private Timer timer;
    private int fade;
    private int verticalOffset;
    private SpinningDial dial;
    private String text;

    public SpinningDialWaitIndicator(JFrame frame) {
        this(frame.getLayeredPane());
        JMenuBar mb = frame.getJMenuBar();
        if (mb != null) {
            this.verticalOffset = mb.getHeight();
        }
    }

    public SpinningDialWaitIndicator(JComponent target) {
        this(target, null);
    }

    public SpinningDialWaitIndicator(JComponent target, String text) {
        super(target);
        this.text = text;
        this.dial = new SpinningDial(){

            public int getIconWidth() {
                Rectangle r = SpinningDialWaitIndicator.this.getComponent().getVisibleRect();
                int margin = Math.min(8, r.width / 8);
                return Math.min(64, r.width - margin * 2);
            }

            public int getIconHeight() {
                Rectangle r = SpinningDialWaitIndicator.this.getComponent().getVisibleRect();
                int margin = Math.min(8, r.height / 8);
                return Math.min(64, r.height - SpinningDialWaitIndicator.this.verticalOffset - margin * 2);
            }
        };
        this.dial.setFrameInterval(0);
    }

    public void setText(String text) {
        this.text = text;
        this.repaint();
    }

    public void paint(Graphics graphics) {
        if (this.timer == null) {
            this.timer = new Timer(41, this);
            this.timer.start();
        }
        Graphics2D g = (Graphics2D)graphics.create();
        Rectangle r = this.getComponent().getVisibleRect();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setColor(AWT.alpha(this.getComponent().getBackground(), this.fade));
        g.fillRect(r.x, r.y, r.width, r.height);
        if (this.fade < 192) {
            return;
        }
        int x = r.x;
        x = this.text == null ? (x += (r.width - this.dial.getIconWidth()) / 2) : (x += this.dial.getIconWidth() / 4);
        int y = r.y + this.verticalOffset + (r.height - this.verticalOffset - this.dial.getIconHeight()) / 2;
        this.dial.paintIcon(this.getPainter(), g, x, y);
        if (this.text != null) {
            Font font = g.getFont();
            g.setFont(font.deriveFont(1, this.dial.getIconHeight() / 2));
            FontMetrics m = g.getFontMetrics();
            g.setColor(this.getComponent().getForeground());
            g.drawString(this.text, x += this.dial.getIconWidth() * 5 / 4, y += this.dial.getIconHeight() - (this.dial.getIconHeight() - m.getAscent()) / 2);
        }
        g.dispose();
    }

    public void dispose() {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
        super.dispose();
    }

    public void actionPerformed(ActionEvent e) {
        if (this.fade < 192) {
            this.fade += 32;
            if (this.fade >= 192) {
                this.timer.setDelay(62);
            }
        } else {
            this.dial.nextFrame();
        }
        this.getPainter().repaint();
    }
}

