/*
 * Decompiled with CFR 0.152.
 */
package abbot.script;

import abbot.script.ArgumentParser;
import abbot.script.Call;
import abbot.script.ComponentReference;
import abbot.script.NoSuchReferenceException;
import abbot.script.Resolver;
import java.lang.reflect.Method;
import java.util.Map;

public abstract class PropertyCall
extends Call {
    private String componentID = null;
    private static final String[] prefixes = new String[]{"is", "has", "get"};
    private static final Class[] returnTypes = new Class[]{Boolean.TYPE, Boolean.TYPE, null};
    static /* synthetic */ Class class$java$awt$Component;
    static /* synthetic */ Class class$abbot$tester$ComponentTester;

    public PropertyCall(Resolver resolver, Map attributes) {
        super(resolver, PropertyCall.patchAttributes(resolver, attributes));
        this.componentID = (String)attributes.get("component");
    }

    public PropertyCall(Resolver resolver, String description, String className, String methodName, String[] args) {
        super(resolver, description, className, methodName, args);
        this.componentID = null;
    }

    public PropertyCall(Resolver resolver, String description, String methodName, String id) {
        super(resolver, description, PropertyCall.getRefClass(resolver, id), methodName, null);
        this.componentID = id;
    }

    public String getComponentID() {
        return this.componentID;
    }

    public void setComponentID(String id) {
        if (id == null) {
            this.componentID = null;
        } else {
            ComponentReference ref = this.getResolver().getComponentReference(id);
            if (ref != null) {
                this.componentID = id;
                this.setTargetClassName(ref.getRefClassName());
            } else {
                throw new NoSuchReferenceException(id);
            }
        }
    }

    public Map getAttributes() {
        Map map = super.getAttributes();
        if (this.componentID != null) {
            map.remove("class");
            map.put("component", this.componentID);
        }
        return map;
    }

    protected Object getTarget(Method m) throws Throwable {
        if (this.componentID != null) {
            return ArgumentParser.eval(this.getResolver(), this.componentID, class$java$awt$Component == null ? (class$java$awt$Component = PropertyCall.class$("java.awt.Component")) : class$java$awt$Component);
        }
        return super.getTarget(m);
    }

    private static Map patchAttributes(Resolver resolver, Map map) {
        String id = (String)map.get("component");
        if (id != null) {
            map.put("class", PropertyCall.getRefClass(resolver, id));
        }
        return map;
    }

    public static boolean isPropertyMethod(Method m) {
        String name = m.getName();
        Class<?> rt = m.getReturnType();
        Class<?>[] params = m.getParameterTypes();
        Class<?> dc = m.getDeclaringClass();
        for (int i = 0; i < prefixes.length; ++i) {
            if (!name.startsWith(prefixes[i]) || name.length() <= prefixes[i].length() || !Character.isUpperCase(name.charAt(prefixes[i].length())) || (!(class$abbot$tester$ComponentTester == null ? PropertyCall.class$("abbot.tester.ComponentTester") : class$abbot$tester$ComponentTester).isAssignableFrom(dc) || params.length != 1 || !(class$java$awt$Component == null ? PropertyCall.class$("java.awt.Component") : class$java$awt$Component).isAssignableFrom(params[0])) && params.length != 0 || returnTypes[i] != null && !returnTypes[i].equals(rt)) continue;
            return true;
        }
        return false;
    }

    public String getDefaultDescription() {
        String desc = super.getDefaultDescription();
        if (this.getComponentID() != null) {
            desc = this.getComponentID() + "." + desc;
        }
        return desc;
    }

    private static String getRefClass(Resolver r, String id) {
        ComponentReference ref = r.getComponentReference(id);
        return ref == null ? (class$java$awt$Component == null ? (class$java$awt$Component = PropertyCall.class$("java.awt.Component")) : class$java$awt$Component).getName() : ref.getRefClassName();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

