/*
 * Decompiled with CFR 0.152.
 */
package abbot.tester;

import abbot.Log;
import abbot.i18n.Strings;
import abbot.tester.ActionFailedException;
import abbot.tester.ComponentLocation;
import abbot.tester.JComponentTester;
import abbot.tester.JListLocation;
import abbot.util.Condition;
import java.awt.Component;
import java.awt.Point;
import javax.swing.JList;
import javax.swing.ListModel;

public class JListTester
extends JComponentTester {
    public static String valueToString(JList list, int index) {
        Object value = list.getModel().getElementAt(index);
        Component cr = list.getCellRenderer().getListCellRendererComponent(list, value, index, false, false);
        String string = JListTester.convertRendererToString(cr);
        return string;
    }

    public Object getElementAt(JList list, int index) {
        return list.getModel().getElementAt(index);
    }

    public int getSize(JList list) {
        return list.getModel().getSize();
    }

    public String[] getContents(JList list) {
        ListModel model = list.getModel();
        String[] values = new String[model.getSize()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = model.getElementAt(i).toString();
        }
        return values;
    }

    public void actionSelectIndex(Component c, int index, long delay) {
        this.actionSelectRow(c, new JListLocation(index), delay);
    }

    public void actionSelectIndex(Component c, int index) {
        this.actionSelectRow(c, new JListLocation(index));
    }

    public void actionSelectItem(Component c, String item, long delay) {
        this.actionSelectRow(c, new JListLocation(item), delay);
    }

    public void actionSelectItem(Component c, String item) {
        this.actionSelectRow(c, new JListLocation(item));
    }

    public void actionSelectValue(Component c, String value) {
        this.actionSelectRow(c, new JListLocation(value));
    }

    public void actionSelectRow(Component c, JListLocation location) {
        this.actionSelectRow(c, location, componentDelay);
    }

    public void actionSelectRow(Component c, final JListLocation location, long delay) {
        final JList list = (JList)c;
        this.wait(new Condition(){

            public boolean test() {
                int index = location.getIndex(list);
                return index >= 0 && index < list.getModel().getSize();
            }

            public String toString() {
                return Strings.get("tester.Component.show_wait", new Object[]{location.toString()});
            }
        }, delay);
        int index = location.getIndex(list);
        if (index < 0 || index >= list.getModel().getSize()) {
            String msg = Strings.get("tester.JList.invalid_index", new Object[]{new Integer(index)});
            throw new ActionFailedException(msg);
        }
        if (list.getSelectedIndex() != index) {
            Log.debug("Click on index=" + index);
            super.actionClick(c, location);
        }
    }

    public ComponentLocation parseLocation(String encoded) {
        return new JListLocation().parse(encoded);
    }

    public ComponentLocation getLocation(Component c, Point p) {
        JList list = (JList)c;
        int index = list.locationToIndex(p);
        String value = JListTester.valueToString(list, index);
        if (value != null) {
            return new JListLocation(value);
        }
        if (index != -1) {
            return new JListLocation(index);
        }
        return new JListLocation(p);
    }
}

