/*
 * Decompiled with CFR 0.152.
 */
package abbot.tester;

import abbot.i18n.Strings;
import abbot.tester.ComponentLocation;
import abbot.tester.LocationUnavailableException;
import abbot.util.ExtendedComparator;
import java.awt.Component;
import java.awt.List;
import java.awt.Point;
import java.awt.Rectangle;

public class ListLocation
extends ComponentLocation {
    private String value = null;
    private int row = -1;

    public ListLocation() {
    }

    public ListLocation(String value) {
        this.value = value;
    }

    public ListLocation(int row) {
        if (row < 0) {
            String msg = Strings.get("tester.JList.invalid_index", new Object[]{new Integer(row)});
            throw new LocationUnavailableException(msg);
        }
        this.row = row;
    }

    public ListLocation(Point where) {
        super(where);
    }

    protected String badFormat(String encoded) {
        return Strings.get("location.list.bad_format", new Object[]{encoded});
    }

    private int valueToIndex(List list, String value) {
        int size = list.getItemCount();
        for (int i = 0; i < size; ++i) {
            if (!ExtendedComparator.stringsMatch(value, list.getItem(i))) continue;
            return i;
        }
        return -1;
    }

    public int getIndex(List list) {
        if (this.value != null) {
            return this.valueToIndex(list, this.value);
        }
        if (this.row != -1) {
            return this.row;
        }
        throw new LocationUnavailableException("Can't derive an index from a Point on java.awt.List");
    }

    public Point getPoint(Component c) {
        List list = (List)c;
        if (this.value != null || this.row != -1) {
            throw new LocationUnavailableException("Can't derive a Point from an index on java.awt.List");
        }
        return super.getPoint(list);
    }

    public Rectangle getBounds(Component c) {
        throw new LocationUnavailableException("Can't determine bounds on java.awt.List");
    }

    public boolean equals(Object o) {
        if (o instanceof ListLocation) {
            ListLocation loc = (ListLocation)o;
            if (this.value != null) {
                return this.value.equals(loc.value);
            }
            if (this.row != -1) {
                return this.row == loc.row;
            }
        }
        return super.equals(o);
    }

    public String toString() {
        if (this.value != null) {
            return this.encodeValue(this.value);
        }
        if (this.row != -1) {
            return this.encodeIndex(this.row);
        }
        return super.toString();
    }

    public ComponentLocation parse(String encoded) {
        if (this.isValue(encoded = encoded.trim())) {
            this.value = this.parseValue(encoded);
            return this;
        }
        if (this.isIndex(encoded)) {
            this.row = this.parseIndex(encoded);
            return this;
        }
        return super.parse(encoded);
    }
}

