/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.component;

import junit.framework.Assert;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.robotframework.javalib.annotation.ArgumentNames;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.swing.context.DefaultContextVerifier;
import org.robotframework.swing.context.IContextVerifier;
import org.robotframework.swing.factory.IdentifierParsingOperatorFactory;
import org.robotframework.swing.keyword.component.ComponentOperatorFactory;
import org.robotframework.swing.util.ComponentExistenceResolver;
import org.robotframework.swing.util.IComponentConditionResolver;

@RobotKeywords
public class ComponentKeywords {
    public static final String __PARANAMER_DATA = "\nclickOnComponent java.lang.String,java.lang.String[] identifier,times \n\ncomponentShouldExist java.lang.String identifier \n\ncomponentShouldNotExist java.lang.String identifier \n";
    private IContextVerifier contextVerifier = new DefaultContextVerifier();
    private IdentifierParsingOperatorFactory<ComponentOperator> operatorFactory = new ComponentOperatorFactory();
    private IComponentConditionResolver componentExistenceResolver = new ComponentExistenceResolver(this.operatorFactory);

    @RobotKeyword(value="Fails if component exists within current context.\nYou might want to set the waiting timeout with the keyword `Set Jemmy Timeout`\n\nExample:\n| Component Should Not Exist | _myPanel_ |\n")
    public void componentShouldNotExist(String identifier) {
        Assert.assertFalse((String)("Component '" + identifier + "' exists"), (boolean)this.componentExistenceResolver.satisfiesCondition(identifier));
    }

    @RobotKeyword(value="Fails if component does not exist within current context.\nYou might want to set the waiting timeout with the keyword `Set Jemmy Timeout`\n\nExample:\n| Component Should Not Exist | _myPanel_ |\n")
    public void componentShouldExist(String identifier) {
        Assert.assertTrue((String)("Component '" + identifier + "' does not exist"), (boolean)this.componentExistenceResolver.satisfiesCondition(identifier));
    }

    @RobotKeyword(value="Clicks on a component.\nThe number of clicks can be given as second argument.\n\nExample:\n| Click On Component | _myComponent_ |   | |\n| Click On Component | _myComponent_ | 2 | # double click |\n")
    @ArgumentNames(value={"identifier", "times=1"})
    public void clickOnComponent(String identifier, String[] times) {
        this.contextVerifier.verifyContext();
        this.createOperator(identifier).clickMouse(this.getTimes(times));
    }

    private ComponentOperator createOperator(String identifier) {
        return this.operatorFactory.createOperator(identifier);
    }

    private int getTimes(String[] times) {
        return times.length == 1 ? Integer.parseInt(times[0]) : 1;
    }
}

