/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.keyboard;

import org.robotframework.javalib.annotation.ArgumentNames;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.swing.keyword.keyboard.KeyEventSender;

@RobotKeywords
public class KeyEventKeywords {
    public static final String __PARANAMER_DATA = "\nsendKeyboardEvent java.lang.String,java.lang.String[] keyCode,modifiers \n";
    private KeyEventSender keyEventSender = new KeyEventSender();

    @RobotKeyword(value="Sends keystrokes to the currently selected component.\nKeystroke codes must be one of the constants in _java.awt.event.KeyEvent_ starting with _VK__.\nConstants from _java.awt.event.InputEvent_ can be used as optional modifiers.\n\nExample with textfield:\n| Select Context        | _myTextfield_        |                      |\n| Send Keyboard Event   | _VK_S_               |                      |\n| Send Keyboard Event   | _VK_O_               |                      |\n| Send Keyboard Event   | _VK_M_               |                      |\n| Send Keyboard Event   | _VK_E_               |                      |\n| Send Keyboard Event   | _VK_T_               | _SHIFT_MASK_         |\n| Send Keyboard Event   | _VK_E_               |                      |\n| Send Keyboard Event   | _VK_X_               |                      |\n| Send Keyboard Event   | _VK_T_               |                      |\n| ${textFieldContents}= | Get Text Field Value | _myTextfield_        |\n| Should Be Equal       | someText             | ${textFieldContents} |\n\nExample with table:\n| SelectTableCell               | _myTable_ | _0_          | _0_ |\n| Send Keyboard Event           | _VK_TAB_  |              |     |\n| Table Cell Should Be Selected | _myTable_ | _0_          | _1_ |\n| Send Keyboard Event           | _VK_TAB_  | _SHIFT_MASK_ |     |\n| Table Cell Should Be Selected | _myTable_ | _0_          | _0_ |\n")
    @ArgumentNames(value={"keyCode", "*modifiers"})
    public void sendKeyboardEvent(String keyCode, String[] modifiers) {
        this.keyEventSender.sendEvent(keyCode, modifiers);
    }
}

