/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.radiobutton;

import junit.framework.Assert;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.swing.button.AbstractButtonOperator;
import org.robotframework.swing.factory.OperatorFactory;
import org.robotframework.swing.radiobutton.RadioButtonOperatorFactory;

@RobotKeywords
public class RadioButtonKeywords {
    public static final String __PARANAMER_DATA = "\npushRadioButton java.lang.String identifier \n\nradioButtonShouldBeSelected java.lang.String identifier \n\nradioButtonShouldNotBeSelected java.lang.String identifier \n\nselectRadioButton java.lang.String identifier \n";
    private OperatorFactory<AbstractButtonOperator> operatorFactory = new RadioButtonOperatorFactory();

    @RobotKeyword(value="Uses current context to search for a radiobutton and when found, pushes it.\n\nExample:\n| Select Radio Button | _My Radio Button_ |\n")
    public void pushRadioButton(String identifier) {
        this.operatorFactory.createOperator(identifier).push();
    }

    @RobotKeyword(value="*DEPRECATED* Use keyword `Push Radio Button` instead.\n")
    public void selectRadioButton(String identifier) {
        this.pushRadioButton(identifier);
    }

    @RobotKeyword(value="Fails if radiobutton is not selected.\n\nExample:\n| Radio Button Should Be Selected | _My Radio Button_ |\n")
    public void radioButtonShouldBeSelected(String identifier) {
        boolean isSelected = this.operatorFactory.createOperator(identifier).isSelected();
        Assert.assertTrue((String)("Radio Button '" + identifier + "' is not selected."), (boolean)isSelected);
    }

    @RobotKeyword(value="Fails if radiobutton is selected.\n\nExample:\n| Radio Button Should Not Be Selected | _My Radio Button_ |\n")
    public void radioButtonShouldNotBeSelected(String identifier) {
        boolean isSelected = this.operatorFactory.createOperator(identifier).isSelected();
        Assert.assertFalse((String)("Radio Button '" + identifier + "' is selected."), (boolean)isSelected);
    }
}

