/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.tab;

import org.netbeans.jemmy.operators.JTabbedPaneOperator;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.swing.common.IdentifierSupport;
import org.robotframework.swing.context.Context;
import org.robotframework.swing.keyword.tab.TabPaneOperatorFactory;

@RobotKeywords
public class TabKeywords
extends IdentifierSupport {
    public static final String __PARANAMER_DATA = "\ngetSelectedTabLabel \n\nselectTab java.lang.String tabIdentifier \n\nselectTabPane java.lang.String identifier \n";
    private TabPaneOperatorFactory operatorFactory = new TabPaneOperatorFactory();

    @RobotKeyword(value="Selects a tab.\nExpects that only one tab pane exists in the current context.\nIf you need to operate on a different tab pane use `Select Tab Pane` keyword first.\n\nExample:\n| Select Tab | _Customer Information_ |\n")
    public void selectTab(String tabIdentifier) {
        if (this.isIndex(tabIdentifier)) {
            this.createTabPane().selectPage(this.asIndex(tabIdentifier));
        } else {
            this.createTabPane().selectPage(tabIdentifier);
        }
    }

    @RobotKeyword(value="Returns the label of the tab that is currenctly selected.\nExpects that only one tab pane exists in the current context.\nIf you need to operate on a different tab pane use `Select Tab Pane` keyword first.\n\nExample:\n| ${currentTab}= | Get Selected Tab Label |\n| Should Be Equal | _Customer Information_ | ${currentTab} |\n")
    public String getSelectedTabLabel() {
        JTabbedPaneOperator paneOperator = this.createTabPane();
        return paneOperator.getTitleAt(paneOperator.getSelectedIndex());
    }

    @RobotKeyword(value="Sets a tab pane as the current context.\nUseful if you have several tab panes in the window.\n\nExample:\n| Select Tab Pane | _Other Tab Pane_ |\n| Select Tab | _Customer Information_ |\n")
    public void selectTabPane(String identifier) {
        Context.setContext(this.operatorFactory.createOperator(identifier));
    }

    private JTabbedPaneOperator createTabPane() {
        return this.operatorFactory.createOperatorFromContext();
    }
}

