/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.timeout;

import org.netbeans.jemmy.JemmyProperties;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;

@RobotKeywords
public class TimeoutKeywords {
    public static final String __PARANAMER_DATA = "\nsetJemmyTimeout java.lang.String,java.lang.String timeoutName,timeoutInSeconds \n\nsetJemmyTimeouts java.lang.String timeoutInSeconds \n";
    public static final String[] JEMMY_TIMEOUTS = new String[]{"DialogWaiter.WaitDialogTimeout", "FrameWaiter.WaitFrameTimeout", "WindowWaiter.WaitWindowTimeout", "ComponentOperator.WaitComponentTimeout", "JMenuOperator.WaitPopupTimeout", "JTreeOperator.WaitNodeExpandedTimeout", "JTreeOperator.WaitNextNodeTimeout", "JTreeOperator.WaitNodeVisibleTimeout", "ComponentOperator.WaitStateTimeout"};

    @RobotKeyword(value="Sets the jemmy timeout used for waiting a component to appear.\nTimeout names are listed here: http://jemmy.netbeans.org/OperatorsEnvironment.html#timeouts.\n\nExample:\n| Set Jemmy Timeout | DialogWaiter.WaitDialogTimeout | 3 |\n")
    public void setJemmyTimeout(String timeoutName, String timeoutInSeconds) {
        JemmyProperties.setCurrentTimeout((String)timeoutName, (long)this.parseMillis(timeoutInSeconds));
    }

    @RobotKeyword(value="Sets all relevant jemmy timeouts. \nBy default they are all set to 5 seconds.\n\nList of all the timeouts this keywords sets:\n| *Timeout Name* | *Description* |\n| DialogWaiter.WaitDialogTimeout | Time to wait dialog displayed |\n| FrameWaiter.WaitFrameTimeout | Time to wait frame displayed |\n| WindowWaiter.WaitWindowTimeout | Time to wait window displayed |\n| ComponentOperator.WaitComponentTimeout | Time to wait component displayed |\n| ComponentOperator.WaitStateTimeout | Used for example in combobox selection |\n| JMenuOperator.WaitPopupTimeout | Time to wait popup displayed |\n| JTreeOperator.WaitNodeExpandedTimeout | Time to wait node expanded |\n| JTreeOperator.WaitNextNodeTimeout | Time to wait next node displayed |\n| JTreeOperator.WaitNodeVisibleTimeout | Time to wait node visible |\n\nExample:\n| Set Jemmy Timeouts | 3 |\n")
    public void setJemmyTimeouts(String timeoutInSeconds) {
        for (String timeout : JEMMY_TIMEOUTS) {
            JemmyProperties.setCurrentTimeout((String)timeout, (long)this.parseMillis(timeoutInSeconds));
        }
    }

    private long parseMillis(String timeoutInSeconds) {
        return Long.parseLong(timeoutInSeconds) * 1000L;
    }
}

