/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.tree;

import abbot.tester.ComponentTester;
import java.awt.Component;
import javax.swing.JMenuItem;
import junit.framework.Assert;
import org.netbeans.jemmy.operators.JPopupMenuOperator;
import org.netbeans.jemmy.operators.Operator;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.swing.comparator.EqualsStringComparator;
import org.robotframework.swing.tree.ITreePopupMenuItemFinder;
import org.robotframework.swing.tree.TreePopupMenuItemFinder;
import org.robotframework.swing.tree.TreeSupport;

@RobotKeywords
public class TreeNodePopupKeywords
extends TreeSupport {
    public static final String __PARANAMER_DATA = "\nselectFromTreeNodePopupMenu java.lang.String,java.lang.String,java.lang.String identifier,nodeIdentifier,menuPath \n\nselectFromTreeNodePopupMenuInSeparateThread java.lang.String,java.lang.String,java.lang.String identifier,nodeIdentifier,menuPath \n\ntreeNodePopupMenuItemShouldBeDisabled java.lang.String,java.lang.String,java.lang.String identifier,nodeIdentifier,menuPath \n\ntreeNodePopupMenuItemShouldBeEnabled java.lang.String,java.lang.String,java.lang.String identifier,nodeIdentifier,menuPath \n";

    @RobotKeyword(value="Selects an item from the tree node's popup menu.\n\nExamples:\n| Select From Tree Node Popup Menu | _myTree_ | _Root|Folder_ | _New Folder_ | ")
    public void selectFromTreeNodePopupMenu(String identifier, String nodeIdentifier, String menuPath) {
        JPopupMenuOperator popupOperator = this.createTreeOperator(identifier).createPopupOperator(nodeIdentifier);
        popupOperator.pushMenu(menuPath, (Operator.StringComparator)new EqualsStringComparator());
    }

    @RobotKeyword(value="Selects an item from the tree node's popup menu and does not wait for a result.\nNeeded if the action starts a process that stays running (e.g. opens a dialog) and the above keyword doesn't return.\nSeparator for items is '|'.\n\nExamples:\n| Select From Tree Node Popup Menu In Separate Thread | _myTree_ | _Root|Folder_ | _New Folder_ | ")
    public void selectFromTreeNodePopupMenuInSeparateThread(String identifier, String nodeIdentifier, String menuPath) {
        JPopupMenuOperator popupOperator = this.createTreeOperator(identifier).createPopupOperator(nodeIdentifier);
        popupOperator.pushMenuNoBlock(menuPath, (Operator.StringComparator)new EqualsStringComparator());
    }

    @RobotKeyword(value="Fails if given popup menu item is disabled.\n\nExample:\n| Tree Node Popup Menu Item Should Be Enabled | _myTree_ | _Root|Folder_ | _New Folder_ |\n| Tree Node Popup Menu Item Should Be Enabled | _0_ | _1_ | _New Folder_ |\n")
    public void treeNodePopupMenuItemShouldBeEnabled(String identifier, String nodeIdentifier, String menuPath) {
        boolean menuItemIsEnabled = this.menuItemIsEnabled(identifier, nodeIdentifier, menuPath);
        Assert.assertTrue((String)("Menu item '" + menuPath + "' was disabled"), (boolean)menuItemIsEnabled);
    }

    @RobotKeyword(value="Fails if given popup menu item is enabled.\n\nExample:\n| Tree Node Popup Menu Item Should Be Disabled | _myTree_ | _Root|Folder_ | _New Folder_ |\n| Tree Node Popup Menu Item Should Be Disabled | _0_      | _1_ | _New Folder_ |\n")
    public void treeNodePopupMenuItemShouldBeDisabled(String identifier, String nodeIdentifier, String menuPath) {
        boolean menuItemIsEnabled = this.menuItemIsEnabled(identifier, nodeIdentifier, menuPath);
        Assert.assertFalse((String)("Menu item '" + menuPath + "' was enabled"), (boolean)menuItemIsEnabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean menuItemIsEnabled(String identifier, String nodeIdentifier, String menuPath) {
        try {
            boolean bl = this.createPopupMenuItem(identifier, nodeIdentifier, menuPath).isEnabled();
            return bl;
        }
        finally {
            this.closePopup();
        }
    }

    private void closePopup() {
        new ComponentTester().actionKeyStroke(27);
    }

    private JMenuItem createPopupMenuItem(String identifier, String nodeIdentifier, String menuPath) {
        Component source = this.createTreeOperator(identifier).getSource();
        return this.createPopupMenuItemFinder(source).findMenu(nodeIdentifier, menuPath);
    }

    ITreePopupMenuItemFinder createPopupMenuItemFinder(Component source) {
        return new TreePopupMenuItemFinder(source);
    }
}

