/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.tree;

import java.awt.Point;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JPopupMenuOperator;
import org.netbeans.jemmy.operators.JTreeOperator;
import org.robotframework.swing.operator.IOperator;
import org.robotframework.swing.popup.DefaultPopupCaller;
import org.robotframework.swing.popup.IPopupCaller;
import org.robotframework.swing.tree.TreePathFactory;
import org.robotframework.swing.tree.TreePathFinder;
import org.robotframework.swing.tree.TreePopupMenuOperatorFactory;

public class TreeOperator
extends JTreeOperator
implements IOperator {
    public static final String __PARANAMER_DATA = "\n<init> javax.swing.JTree tree \n\n<init> org.netbeans.jemmy.operators.ContainerOperator,int containerOperator,index \n\n<init> org.netbeans.jemmy.operators.ContainerOperator,org.netbeans.jemmy.ComponentChooser containerOperator,componentChooser \n\nisCollapsed java.lang.String nodeIdentifier \n\nisExpanded java.lang.String nodeIdentifier \n\nisLeaf java.lang.String nodeIdentifier \n\nisPathSelected java.lang.String nodeIdentifier \n\nisVisible java.lang.String nodeIdentifier \n\ncallPopupOnRow int row \n\nfindPath java.lang.String treePath \n\ncreatePopupOperator java.lang.String nodeIdentifier \n\naddSelection java.lang.String nodeIdentifier \n\ncollapse java.lang.String nodeIdentifier \n\nexpand java.lang.String nodeIdentifier \n\nremoveSelection java.lang.String nodeIdentifier \n";
    private IPopupCaller popupCaller = new DefaultPopupCaller();
    private TreePathFactory treePathFactory = new TreePathFactory(this);

    public TreeOperator(ContainerOperator containerOperator, ComponentChooser componentChooser) {
        super(containerOperator, componentChooser);
    }

    public TreeOperator(ContainerOperator containerOperator, int index) {
        super(containerOperator, index);
    }

    public TreeOperator(JTree tree) {
        super(tree);
    }

    public JPopupMenu callPopupOnRow(int row) {
        this.selectRow(row);
        this.scrollToRow(row);
        Point pointToClick = this.getPointToClick(row);
        return this.popupCaller.callPopupOnComponent((ComponentOperator)this, pointToClick);
    }

    public TreePath findPath(String treePath) {
        try {
            return (TreePath)this.createTreeWaiter(treePath).waitAction(null);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void expand(String nodeIdentifier) {
        this.expandPath(this.createTreePath(nodeIdentifier));
    }

    public void collapse(String nodeIdentifier) {
        this.collapsePath(this.createTreePath(nodeIdentifier));
    }

    public void addSelection(String nodeIdentifier) {
        this.addSelectionPath(this.createTreePath(nodeIdentifier));
    }

    public void removeSelection(String nodeIdentifier) {
        this.removeSelectionPath(this.createTreePath(nodeIdentifier));
    }

    public boolean isExpanded(String nodeIdentifier) {
        return this.isExpanded(this.createTreePath(nodeIdentifier));
    }

    public boolean isCollapsed(String nodeIdentifier) {
        return this.isCollapsed(this.createTreePath(nodeIdentifier));
    }

    public boolean isLeaf(String nodeIdentifier) {
        TreeNode lastPathComponent = (TreeNode)this.createTreePath(nodeIdentifier).getLastPathComponent();
        return lastPathComponent.isLeaf();
    }

    public boolean isPathSelected(String nodeIdentifier) {
        return this.isPathSelected(this.createTreePath(nodeIdentifier));
    }

    public boolean isVisible(String nodeIdentifier) {
        return this.isVisible(this.createTreePath(nodeIdentifier));
    }

    public JPopupMenuOperator createPopupOperator(String nodeIdentifier) {
        return (JPopupMenuOperator)this.createPopupFactory().createOperator(nodeIdentifier);
    }

    TreePopupMenuOperatorFactory createPopupFactory() {
        return new TreePopupMenuOperatorFactory(this);
    }

    private TreePath createTreePath(String nodeIdentifier) {
        return this.treePathFactory.createTreePath(nodeIdentifier);
    }

    private Waiter createTreeWaiter(String treePath) {
        Waiter waiter = new Waiter((Waitable)new TreePathWaitable(treePath));
        Timeouts nextNodeTimeout = this.copyTimeout("JTreeOperator.WaitNextNodeTimeout");
        waiter.setTimeouts(nextNodeTimeout);
        return waiter;
    }

    private Timeouts copyTimeout(String timeout) {
        Timeouts times = this.getTimeouts().cloneThis();
        times.setTimeout("Waiter.WaitingTime", this.getTimeouts().getTimeout(timeout));
        return times;
    }

    private class TreePathWaitable
    implements Waitable {
        public static final String __PARANAMER_DATA = "\nactionProduced java.lang.Object arg0 \n\ngetDescription \n";
        private final String path;

        private TreePathWaitable(String path) {
            this.path = path;
        }

        public Object actionProduced(Object arg0) {
            return new TreePathFinder(TreeOperator.this).findPath(this.path);
        }

        public String getDescription() {
            return "Tree path";
        }
    }
}

