/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.sifr;

import org.apache.wicket.Component;
import org.apache.wicket.IClusterable;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.Response;
import org.apache.wicket.behavior.AbstractBehavior;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.resources.JavascriptResourceReference;

public class AbstractFlashTextBehavior
extends AbstractBehavior
implements IHeaderContributor {
    private static final long serialVersionUID = 1L;
    private static final ResourceReference SIFR_JS = new JavascriptResourceReference(class$org$wicketstuff$sifr$FlashTextBehavior == null ? (class$org$wicketstuff$sifr$FlashTextBehavior = AbstractFlashTextBehavior.class$("org.wicketstuff.sifr.FlashTextBehavior")) : class$org$wicketstuff$sifr$FlashTextBehavior, "sifr.js");
    private static final ResourceReference SIFR_SCREEN_CSS = new ResourceReference(class$org$wicketstuff$sifr$FlashTextBehavior == null ? (class$org$wicketstuff$sifr$FlashTextBehavior = AbstractFlashTextBehavior.class$("org.wicketstuff.sifr.FlashTextBehavior")) : class$org$wicketstuff$sifr$FlashTextBehavior, "sIFR-screen.css");
    private static final ResourceReference SIFR_PRINT_CSS = new ResourceReference(class$org$wicketstuff$sifr$FlashTextBehavior == null ? (class$org$wicketstuff$sifr$FlashTextBehavior = AbstractFlashTextBehavior.class$("org.wicketstuff.sifr.FlashTextBehavior")) : class$org$wicketstuff$sifr$FlashTextBehavior, "sIRF-print.css");
    static /* synthetic */ Class class$org$wicketstuff$sifr$FlashTextBehavior;

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.renderJavascriptReference(SIFR_JS);
        response.renderCSSReference(SIFR_SCREEN_CSS, "screen");
        response.renderCSSReference(SIFR_PRINT_CSS, "print");
    }

    protected void replaceElement(Component component, String id, FlashTextSettings settings) {
        Response response = component.getResponse();
        response.write((CharSequence)"<script type=\"text/javascript\"><!--/*--><![CDATA[/*><!--*/\n");
        response.write((CharSequence)"if(typeof sIFR == \"function\")");
        response.write((CharSequence)("sIFR.replaceElement(\"" + id + "\", "));
        response.write((CharSequence)("named({sFlashSrc: \"" + RequestCycle.get().urlFor(settings.font) + "\""));
        this.writeProperty(response, "sColor", settings.color);
        this.writeProperty(response, "sWmode", settings.transparent != null ? "transparent" : null);
        this.writeProperty(response, "sLinkColor", settings.linkColor);
        this.writeProperty(response, "sHoverColor", settings.hoverColor);
        this.writeProperty(response, "sBgColor", settings.bgColor);
        this.writeProperty(response, "nPaddingTop", settings.paddingTop);
        this.writeProperty(response, "nPaddingRight", settings.paddingRight);
        this.writeProperty(response, "nPaddingBottom", settings.paddingBottom);
        this.writeProperty(response, "nPaddingLeft", settings.paddingLeft);
        response.write((CharSequence)"}));");
        response.write((CharSequence)"\n/*-->]]>*/</script>\n");
    }

    private void writeProperty(Response response, String key, Object value) {
        if (value != null) {
            response.write((CharSequence)(", " + key + ":\"" + value.toString() + "\""));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class FlashTextSettings
    implements IClusterable {
        private static final long serialVersionUID = 1L;
        ResourceReference font;
        String color;
        String linkColor;
        String hoverColor;
        String bgColor;
        Integer paddingTop;
        Integer paddingRight;
        Integer paddingBottom;
        Integer paddingLeft;
        Boolean transparent;

        public FlashTextSettings(ResourceReference font) {
            this.font = font;
        }

        public ResourceReference getFont() {
            return this.font;
        }

        public FlashTextSettings setFont(ResourceReference font) {
            this.font = font;
            return this;
        }

        public String getColor() {
            return this.color;
        }

        public FlashTextSettings setColor(String color) {
            this.color = color;
            return this;
        }

        public String getLinkColor() {
            return this.linkColor;
        }

        public FlashTextSettings setLinkColor(String linkColor) {
            this.linkColor = linkColor;
            return this;
        }

        public String getHoverColor() {
            return this.hoverColor;
        }

        public FlashTextSettings setHoverColor(String hoverColor) {
            this.hoverColor = hoverColor;
            return this;
        }

        public String getBgColor() {
            return this.bgColor;
        }

        public FlashTextSettings setBgColor(String bgColor) {
            this.bgColor = bgColor;
            return this;
        }

        public Integer getPaddingTop() {
            return this.paddingTop;
        }

        public FlashTextSettings setPaddingTop(Integer paddingTop) {
            this.paddingTop = paddingTop;
            return this;
        }

        public Integer getPaddingRight() {
            return this.paddingRight;
        }

        public FlashTextSettings setPaddingRight(Integer paddingRight) {
            this.paddingRight = paddingRight;
            return this;
        }

        public Integer getPaddingBottom() {
            return this.paddingBottom;
        }

        public FlashTextSettings setPaddingBottom(Integer paddingBottom) {
            this.paddingBottom = paddingBottom;
            return this;
        }

        public Integer getPaddingLeft() {
            return this.paddingLeft;
        }

        public FlashTextSettings setPaddingLeft(Integer paddingLeft) {
            this.paddingLeft = paddingLeft;
            return this;
        }

        public Boolean isTransparent() {
            return this.transparent;
        }

        public FlashTextSettings setTransparent(Boolean transparent) {
            this.transparent = transparent;
            return this;
        }
    }
}

