/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.yui;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YuiDependencyResolver
implements Serializable {
    private final Map<String, Set<String>> deps = Collections.synchronizedMap(new HashMap());
    private static final Logger log = LoggerFactory.getLogger(YuiDependencyResolver.class);

    public Set<String> resolveDependencies(String module, String path) {
        if (this.deps.containsKey(module)) {
            return this.deps.get(module);
        }
        LinkedHashSet<String> depmods = new LinkedHashSet<String>();
        this.fetchModuleDependencies(depmods, module, path);
        this.deps.put(module, depmods);
        return depmods;
    }

    public boolean hasCssAsset(String module, String path) {
        String asset = String.valueOf(path) + "/" + module + "/assets/" + module + ".css";
        URL url = this.getClass().getResource(asset);
        return url != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void fetchModuleDependencies(Set<String> deps, String module, String path) {
        String baseName = String.valueOf(path) + "/" + module + "/" + module;
        InputStream is = this.getClass().getResourceAsStream(String.valueOf(baseName) + ".js");
        if (is == null) {
            if (log.isDebugEnabled()) {
                log.debug("Unable to find " + baseName + ".js" + ". Trying beta...");
            }
            if ((is = this.getClass().getResourceAsStream(String.valueOf(baseName) + "-beta.js")) == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Unable to find " + baseName + "-beta.js" + ". Trying experimental...");
                }
                if ((is = this.getClass().getResourceAsStream(String.valueOf(baseName) + "-experimental.js")) == null) {
                    if (!log.isInfoEnabled()) return;
                    log.info("No Module found for " + module);
                    return;
                }
            }
        }
        BufferedReader buffy = new BufferedReader(new InputStreamReader(is));
        Pattern pattern = Pattern.compile("\\* @requires (.*)");
        String dependencies = "";
        try {
            String line;
            while ((line = buffy.readLine()) != null) {
                Matcher matcher = pattern.matcher(line);
                if (!matcher.find()) continue;
                if (log.isInfoEnabled()) {
                    log.info("Found a match with " + line);
                }
                dependencies = matcher.group(1);
                break;
            }
            if (dependencies.contains(",")) {
                String[] splitDeps;
                String[] stringArray = splitDeps = dependencies.split(",");
                int n = splitDeps.length;
                int n2 = 0;
                while (n2 < n) {
                    String sdep = stringArray[n2];
                    if (!Strings.isEmpty((CharSequence)sdep)) {
                        String tdep = sdep.trim();
                        tdep = tdep.toLowerCase();
                        this.fetchModuleDependencies(deps, tdep, path);
                        deps.add(tdep);
                    }
                    ++n2;
                }
                return;
            } else if (!Strings.isEmpty((CharSequence)dependencies)) {
                String tdep = dependencies.trim();
                tdep = tdep.toLowerCase();
                this.fetchModuleDependencies(deps, tdep, path);
                deps.add(tdep);
            }
            return;
        }
        catch (IOException e) {
            log.error("error reading " + baseName, (Throwable)e);
            return;
        }
        finally {
            try {
                buffy.close();
            }
            catch (IOException e) {
                log.error("unable to close BufferedReader", (Throwable)e);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) {
        pat = Pattern.compile("\\* @requires (.*)");
        baseDir = "/home/jim/src/wicket/wicket-stuff/wicket-contrib-yui/src/main/java/org/wicketstuff/yui/inc/2.2.2";
        dir = new File("/home/jim/src/wicket/wicket-stuff/wicket-contrib-yui/src/main/java/org/wicketstuff/yui/inc/2.2.2");
        ff = new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory() && !pathname.getName().startsWith(".");
            }
        };
        var9_6 = files = dir.listFiles(ff);
        var8_7 = files.length;
        var7_8 = 0;
        while (var7_8 < var8_7) {
            block9: {
                block8: {
                    file = var9_6[var7_8];
                    dirName = file.getName();
                    YuiDependencyResolver.log.info("checking directory: " + file.getName());
                    script = "/home/jim/src/wicket/wicket-stuff/wicket-contrib-yui/src/main/java/org/wicketstuff/yui/inc/2.2.2/" + dirName + "/" + dirName;
                    scriptFile = new File(String.valueOf(script) + ".js");
                    if (!scriptFile.exists()) break block8;
                    YuiDependencyResolver.log.info("Found script file " + scriptFile.getName());
                    ** GOTO lbl30
                }
                YuiDependencyResolver.log.info("couldn't find " + scriptFile.getName() + " will try with beta next");
                scriptFile = new File(String.valueOf(script) + "-beta.js");
                if (!scriptFile.exists()) break block9;
                YuiDependencyResolver.log.info("Found script file " + scriptFile.getName());
                ** GOTO lbl30
            }
            YuiDependencyResolver.log.info("couldn't find " + scriptFile.getName() + " will try experimental next");
            scriptFile = new File(String.valueOf(script) + "-experimental.js");
            if (!scriptFile.exists()) {
                YuiDependencyResolver.log.info("couldn't find " + scriptFile.getName() + ". Giving up");
            } else {
                YuiDependencyResolver.log.info("Found script file " + scriptFile.getName());
lbl30:
                // 3 sources

                try {
                    raf = new RandomAccessFile(scriptFile, "r");
                    bytes = new byte[(int)raf.length()];
                    raf.read(bytes);
                    contents = new String(bytes);
                    match = pat.matcher(contents);
                    if (match.find()) {
                        YuiDependencyResolver.log.info("We have a match in " + scriptFile + ": " + match.group(1));
                        YuiDependencyResolver.log.info("Starting at " + match.start() + " ending at " + match.end());
                    } else {
                        YuiDependencyResolver.log.info("no match for pattern in " + scriptFile);
                    }
                }
                catch (FileNotFoundException e) {
                    YuiDependencyResolver.log.error("Not found", (Throwable)e);
                }
                catch (IOException e) {
                    YuiDependencyResolver.log.error("Can't open", (Throwable)e);
                }
            }
            ++var7_8;
        }
    }
}

