/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.yui;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.behavior.AbstractHeaderContributor;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.resources.CompressedResourceReference;
import org.apache.wicket.markup.html.resources.JavascriptResourceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.yui.YuiDependencyResolver;

public class YuiHeaderContributor
extends AbstractHeaderContributor {
    private static final Logger log = LoggerFactory.getLogger(YuiHeaderContributor.class);
    static final String DEFAULT_YUI_BUILD = "2.2.2";
    static final String YUI_BUILD_ROOT = "inc";
    static final Map<String, ResourceReference> moduleCache = Collections.synchronizedMap(new HashMap());
    static final YuiDependencyResolver dependencyResolver = new YuiDependencyResolver();
    List<YuiModuleHeaderContributor> contributors = new ArrayList<YuiModuleHeaderContributor>();

    public IHeaderContributor[] getHeaderContributors() {
        return this.contributors.toArray(new IHeaderContributor[0]);
    }

    private void addModuleHeaderContributor(String name, String build, boolean debug) {
        this.contributors.add(new YuiModuleHeaderContributor(name, build, debug));
    }

    public static YuiHeaderContributor forModule(String module) {
        return YuiHeaderContributor.forModule(module, null);
    }

    public static YuiHeaderContributor forModule(String module, String[] optionalDependencies) {
        return YuiHeaderContributor.forModule(module, optionalDependencies, false);
    }

    public static YuiHeaderContributor forModule(String name, String[] optionalDependencies, boolean debug) {
        return YuiHeaderContributor.forModule(name, optionalDependencies, debug, DEFAULT_YUI_BUILD);
    }

    public static YuiHeaderContributor forModule(String name, String[] optionalDependencies, boolean debug, String build) {
        YuiHeaderContributor yhc = new YuiHeaderContributor();
        Set<String> dependencies = dependencyResolver.resolveDependencies(name, "inc/" + build);
        for (String dep : dependencies) {
            yhc.addModuleHeaderContributor(dep, build, debug);
        }
        if (optionalDependencies != null && optionalDependencies.length != 0) {
            String[] stringArray = optionalDependencies;
            int n = optionalDependencies.length;
            int n2 = 0;
            while (n2 < n) {
                String opts = stringArray[n2];
                yhc.addModuleHeaderContributor(opts, build, debug);
                ++n2;
            }
        }
        yhc.addModuleHeaderContributor(name, build, debug);
        return yhc;
    }

    class YuiModuleHeaderContributor
    implements IHeaderContributor {
        private final String name;
        private final String build;
        private final boolean debug;

        public YuiModuleHeaderContributor(String name, String build, boolean debug) {
            this.name = name;
            this.build = build;
            this.debug = debug;
        }

        private String getRealModuleName(String path, String module) {
            String fullPath = String.valueOf(path) + "/" + module + "/";
            URL url = this.getClass().getResource(String.valueOf(fullPath) + module + ".js");
            if (url != null) {
                return module;
            }
            url = this.getClass().getResource(String.valueOf(fullPath) + module + "-beta.js");
            if (url != null) {
                return String.valueOf(module) + "-beta";
            }
            url = this.getClass().getResource(String.valueOf(fullPath) + module + "-experimental.js");
            if (url != null) {
                return String.valueOf(module) + "experimental";
            }
            return null;
        }

        public void renderHead(IHeaderResponse response) {
            String buildPath = "inc/" + this.build;
            String realName = this.getRealModuleName(buildPath, this.name);
            if (realName != null) {
                Object moduleScript;
                String path = String.valueOf(buildPath) + "/" + this.name + "/" + realName + (this.debug ? "-debug.js" : ".js");
                if (moduleCache.containsKey(path)) {
                    moduleScript = moduleCache.get(path);
                } else {
                    moduleScript = this.debug ? new ResourceReference(YuiHeaderContributor.class, path) : new JavascriptResourceReference(YuiHeaderContributor.class, path);
                    moduleCache.put(path, (ResourceReference)moduleScript);
                }
                response.renderJavascriptReference(moduleScript);
                if (dependencyResolver.hasCssAsset(this.name, "inc/" + this.build)) {
                    ResourceReference assetRef;
                    String assetPath = "inc/" + this.build + "/" + this.name + "/assets/" + this.name + ".css";
                    if (moduleCache.containsKey(assetPath)) {
                        assetRef = moduleCache.get(assetPath);
                    } else {
                        assetRef = new CompressedResourceReference(YuiHeaderContributor.class, assetPath);
                        moduleCache.put(assetPath, assetRef);
                    }
                    response.renderCSSReference(assetRef, "screen");
                }
            } else {
                log.error("Unable to find realName for Yui Module " + this.name);
            }
        }
    }
}

