/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.yui.markup.html.anim;

import java.util.HashMap;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.behavior.StringHeaderContributor;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.template.PackagedTextTemplate;
import org.wicketstuff.yui.YuiHeaderContributor;
import org.wicketstuff.yui.markup.html.anim.AnimOption;
import org.wicketstuff.yui.markup.html.anim.AnimSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnimGroup
extends WebMarkupContainer {
    private static final long serialVersionUID = 1L;
    private String javaScriptId;
    private List<AnimOption> animOptionList;
    private String easing;
    private double duration;
    private int maxSelection;
    private String selectedValues = "";
    private String valueId;

    public AnimGroup(String id, AnimSettings settings, final FormComponent element) {
        super(id);
        this.add((IBehavior)YuiHeaderContributor.forModule("animation"));
        this.animOptionList = settings.getAnimOptionList();
        this.easing = settings.getEasing();
        this.duration = settings.getDuration();
        this.maxSelection = settings.getMaxSelection();
        this.valueId = String.valueOf(element.getId()) + "_" + id;
        int i = 0;
        while (i < this.animOptionList.size()) {
            AnimOption animSelectOption = this.animOptionList.get(i);
            String value = animSelectOption.getSelectedValue();
            this.selectedValues = this.selectedValues.equals("") ? "'" + value + "'" : String.valueOf(this.selectedValues) + ",'" + value + "'";
            ++i;
        }
        if (element != null) {
            element.add((IBehavior)new AttributeModifier("id", true, (IModel)new AbstractReadOnlyModel(){
                private static final long serialVersionUID = 1L;

                public Object getObject() {
                    return String.valueOf(element.getId()) + "_" + AnimGroup.this.javaScriptId;
                }
            }));
        }
        this.add((Component)element);
    }

    public List<AnimOption> getAnimOptionList() {
        return this.animOptionList;
    }

    public double getDuration() {
        return this.duration;
    }

    public String getEasing() {
        return this.easing;
    }

    public String getJavaScriptId() {
        return this.javaScriptId;
    }

    public int getMaxSelection() {
        return this.maxSelection;
    }

    public String getSelectedValues() {
        return this.selectedValues;
    }

    public void setAnimOptionList(List<AnimOption> animOptionList) {
        this.animOptionList = animOptionList;
    }

    public void setDuration(double duration) {
        this.duration = duration;
    }

    public void setEasing(String easing) {
        this.easing = easing;
    }

    public void setJavaScriptId(String javaScriptId) {
        this.javaScriptId = javaScriptId;
    }

    public void setMaxSelection(int maxSelection) {
        this.maxSelection = maxSelection;
    }

    public void setSelectedValues(String selectedValues) {
        this.selectedValues = selectedValues;
    }

    protected String getJavaScriptComponentInitializationScript() {
        PackagedTextTemplate template = new PackagedTextTemplate(AnimGroup.class, "init.js");
        HashMap<String, Object> variables = new HashMap<String, Object>(7);
        variables.put("javaScriptId", this.javaScriptId);
        variables.put("easing", "'" + this.easing + "'");
        variables.put("duration", new Double(this.duration));
        variables.put("maxSelection", new Integer(this.maxSelection));
        variables.put("noOfBoxes", new Integer(this.animOptionList.size()));
        variables.put("selectedValues", this.selectedValues);
        variables.put("valueId", "'" + this.valueId + "'");
        template.interpolate(variables);
        return template.getString();
    }

    protected void onBeforeRender() {
        super.onBeforeRender();
        this.javaScriptId = this.getMarkupId();
        String js = "\n<script type=\"text/javascript\">" + this.getJavaScriptComponentInitializationScript() + "\n</script>\n";
        this.add((IBehavior)new StringHeaderContributor(js));
    }

    protected void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        super.onComponentTagBody(markupStream, openTag);
    }
}

