/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.yui.markup.html.animselect;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.template.PackagedTextTemplate;
import org.wicketstuff.yui.InlineStyle;
import org.wicketstuff.yui.YuiHeaderContributor;
import org.wicketstuff.yui.YuiImage;
import org.wicketstuff.yui.markup.html.animselect.AnimSelectOption;
import org.wicketstuff.yui.markup.html.animselect.AnimSelectOptionGroup;
import org.wicketstuff.yui.markup.html.animselect.AnimSelectSettings;

public class AnimSelectOptionBox
extends Panel {
    private static final long serialVersionUID = 1L;
    private double duration;
    private String easing;
    private String javaScriptId;
    private int maxSelection;
    private String message;
    private AnimSelectSettings settings;

    public AnimSelectOptionBox(String id, final int index, AnimSelectOption animSelectOption, AnimSelectSettings settings) {
        super(id);
        this.add((IBehavior)YuiHeaderContributor.forModule("animation"));
        this.settings = settings;
        this.easing = settings.getEasing();
        this.duration = settings.getDuration();
        this.maxSelection = settings.getMaxSelection();
        this.message = settings.getMessage();
        ImgStyle style = new ImgStyle("imgStyle");
        this.add((Component)style);
        style.add((Component)new AnimSelectBox("defaultImg", index, "DefaultImg", animSelectOption.getDefaultImg()));
        style.add((Component)new AnimSelectBox("defaultImgOver", index, "DefaultImgOver", animSelectOption.getDefaultImgOver()));
        style.add((Component)new AnimSelectBox("selectedImg", index, "SelectedImg", animSelectOption.getSelectedImg()));
        style.add((Component)new AnimSelectBox("selectedImgOver", index, "SelectedImgOver", animSelectOption.getSelectedImgOver()));
        Label animSelect = new Label("animSelectScript", (IModel)new AbstractReadOnlyModel(){
            private static final long serialVersionUID = 1L;

            public Object getObject() {
                return AnimSelectOptionBox.this.getAnimSelectInitializationScript(index);
            }
        });
        animSelect.setEscapeModelStrings(false);
        this.add((Component)animSelect);
    }

    protected String getAnimSelectInitializationScript(int boxId) {
        PackagedTextTemplate template = new PackagedTextTemplate(AnimSelectOptionBox.class, "animselect.js");
        HashMap<String, Object> variables = new HashMap<String, Object>(7);
        variables.put("javaScriptId", this.javaScriptId);
        variables.put("boxId", new Integer(boxId));
        variables.put("easing", "YAHOO.util.Easing." + this.easing);
        variables.put("duration", new Double(this.duration));
        variables.put("maxSelection", new Integer(this.maxSelection));
        variables.put("noOfBoxes", new Integer(this.settings.getAnimSelectOptionList().size()));
        if (this.message == null || this.message.equals("")) {
            this.message = "Up to " + this.maxSelection + " selections allowed!";
        }
        variables.put("message", this.message);
        template.interpolate(variables);
        return template.getString();
    }

    protected void onAttach() {
        super.onAttach();
        this.javaScriptId = this.findParent(AnimSelectOptionGroup.class).getMarkupId();
    }

    private final class AnimSelectBox
    extends FormComponent
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public AnimSelectBox(String id, final int count, final String name, YuiImage yuiImage) {
            super(id);
            this.add((IBehavior)new AttributeModifier("id", true, (IModel)new AbstractReadOnlyModel(){
                private static final long serialVersionUID = 1L;

                public Object getObject() {
                    return String.valueOf(name) + count + "_" + AnimSelectOptionBox.this.javaScriptId;
                }
            }));
            this.add((IBehavior)new AttributeModifier("style", true, (IModel)new AbstractReadOnlyModel(){
                private static final long serialVersionUID = 1L;

                public Object getObject() {
                    if (name.equals("DefaultImg")) {
                        List<InlineStyle> aInlineStyleList = AnimSelectOptionBox.this.settings.getDefaultImgStyleList();
                        InlineStyle aInlineStyle = aInlineStyleList.get(0);
                        return aInlineStyle.getStyle();
                    }
                    if (name.equals("DefaultImgOver")) {
                        List<InlineStyle> aInlineStyleList = AnimSelectOptionBox.this.settings.getDefaultImgOverStyleList();
                        InlineStyle aInlineStyle = aInlineStyleList.get(0);
                        return aInlineStyle.getStyle();
                    }
                    if (name.equals("SelectedImg")) {
                        List<InlineStyle> aInlineStyleList = AnimSelectOptionBox.this.settings.getSelectedImgStyleList();
                        InlineStyle aInlineStyle = aInlineStyleList.get(0);
                        return aInlineStyle.getStyle();
                    }
                    if (name.equals("SelectedImgOver")) {
                        List<InlineStyle> aInlineStyleList = AnimSelectOptionBox.this.settings.getSelectedImgOverStyleList();
                        InlineStyle aInlineStyle = aInlineStyleList.get(0);
                        return aInlineStyle.getStyle();
                    }
                    return new String("");
                }
            }));
        }
    }

    private final class ImgStyle
    extends FormComponent
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public ImgStyle(String id) {
            super(id);
            this.add((IBehavior)new AttributeModifier("style", true, (IModel)new AbstractReadOnlyModel(){
                private static final long serialVersionUID = 1L;

                public Object getObject() {
                    return "width:" + AnimSelectOptionBox.this.settings.getWidth() + "px; height:" + AnimSelectOptionBox.this.settings.getHeight() + "px";
                }
            }));
        }
    }
}

