/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.yui.markup.html.dragdrop;

import java.util.HashMap;
import java.util.Map;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.template.PackagedTextTemplate;
import org.apache.wicket.util.template.TextTemplate;
import org.apache.wicket.util.template.TextTemplateHeaderContributor;
import org.wicketstuff.yui.YuiHeaderContributor;
import org.wicketstuff.yui.YuiImage;
import org.wicketstuff.yui.markup.html.dragdrop.DragDropDragableSlot;
import org.wicketstuff.yui.markup.html.dragdrop.DragDropPlayer;
import org.wicketstuff.yui.markup.html.dragdrop.DragDropSettings;
import org.wicketstuff.yui.markup.html.dragdrop.DragDropTargetSlot;
import org.wicketstuff.yui.markup.html.dragdrop.DragableSlot;
import org.wicketstuff.yui.markup.html.dragdrop.DragableSlotList;
import org.wicketstuff.yui.markup.html.dragdrop.TargetSlot;
import org.wicketstuff.yui.markup.html.dragdrop.TargetSlotList;

public class DragDropGroup
extends WebMarkupContainer {
    private static final long serialVersionUID = 1L;
    private DragableSlotList dragableSlotList;
    private TargetSlotList targetSlotList;
    private String javaScriptId;

    public DragDropGroup(String id, final DragDropSettings settings, final FormComponent dragableElement, final FormComponent targetElement) {
        super(id);
        this.add((IBehavior)YuiHeaderContributor.forModule("dragdrop"));
        this.dragableSlotList = settings.getDragableSlotList();
        this.targetSlotList = settings.getTargetSlotList();
        if (dragableElement != null) {
            dragableElement.add((IBehavior)new AttributeModifier("id", true, (IModel)new AbstractReadOnlyModel(){
                private static final long serialVersionUID = 1L;

                public Object getObject() {
                    return String.valueOf(dragableElement.getId()) + "_" + DragDropGroup.this.javaScriptId;
                }
            }));
        }
        this.add((Component)dragableElement);
        if (targetElement != null) {
            targetElement.add((IBehavior)new AttributeModifier("id", true, (IModel)new AbstractReadOnlyModel(){
                private static final long serialVersionUID = 1L;

                public Object getObject() {
                    return String.valueOf(targetElement.getId()) + "_" + DragDropGroup.this.javaScriptId;
                }
            }));
        }
        this.add((Component)targetElement);
        ListView targetSlotView = new ListView(this.targetSlotList.getId(), this.targetSlotList.getTargetList()){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem item) {
                TargetSlot targetSlot = (TargetSlot)item.getModelObject();
                YuiImage slot = targetSlot.getSlot();
                item.add((Component)new DragDropTargetSlot(DragDropGroup.this.targetSlotList.getSlotId(), item.getIndex(), slot, settings));
            }
        };
        this.add((Component)targetSlotView);
        ListView dragableSlotView = new ListView(this.dragableSlotList.getId(), this.dragableSlotList.getDragableList()){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem item) {
                DragableSlot dragableSlot = (DragableSlot)item.getModelObject();
                YuiImage slot = dragableSlot.getSlot();
                YuiImage img = dragableSlot.getImage();
                item.add((Component)new DragDropDragableSlot(DragDropGroup.this.dragableSlotList.getSlotId(), item.getIndex(), slot, settings));
                item.add((Component)new DragDropPlayer(DragDropGroup.this.dragableSlotList.getImgId(), item.getIndex(), img, settings));
            }
        };
        this.add((Component)dragableSlotView);
    }

    protected Map getJavaScriptComponentInitializationVariables() {
        String targetSlot = "";
        int i = 0;
        while (i < this.targetSlotList.getSize()) {
            targetSlot = targetSlot.equals("") || targetSlot == "" ? "'empty'" : String.valueOf(targetSlot) + ", 'empty'";
            ++i;
        }
        String targetSlotId = "";
        int i2 = 0;
        while (i2 < this.targetSlotList.getSize()) {
            TargetSlot target = this.targetSlotList.getTargetSlot(i2);
            targetSlotId = targetSlotId.equals("") || targetSlotId == "" ? "'" + target.getSlot().getDesc() + "'" : String.valueOf(targetSlotId) + ", '" + target.getSlot().getDesc() + "'";
            ++i2;
        }
        String dragSlot = "";
        int i3 = 0;
        while (i3 < this.dragableSlotList.getSize()) {
            DragableSlot dragable = this.dragableSlotList.getDragableSlot(i3);
            dragSlot = dragSlot.equals("") || dragSlot == "" ? "'" + dragable.getImage().getDesc() + "'" : String.valueOf(dragSlot) + ", '" + dragable.getImage().getDesc() + "'";
            ++i3;
        }
        String dragSlotId = "";
        int i4 = 0;
        while (i4 < this.dragableSlotList.getSize()) {
            DragableSlot dragable = this.dragableSlotList.getDragableSlot(i4);
            dragSlotId = dragSlotId.equals("") || dragSlotId == "" ? "'" + dragable.getSlot().getDesc() + "'" : String.valueOf(dragSlotId) + ", '" + dragable.getSlot().getDesc() + "'";
            ++i4;
        }
        HashMap<String, String> variables = new HashMap<String, String>(5);
        variables.put("javaScriptId", this.javaScriptId);
        variables.put("targetSlot", targetSlot);
        variables.put("targetSlotId", targetSlotId);
        variables.put("dragSlot", dragSlot);
        variables.put("dragSlotId", dragSlotId);
        return variables;
    }

    protected void onBeforeRender() {
        super.onBeforeRender();
        this.javaScriptId = this.getMarkupId();
        PackagedTextTemplate template = new PackagedTextTemplate(DragDropGroup.class, "init.js");
        this.add((IBehavior)TextTemplateHeaderContributor.forJavaScript((TextTemplate)template, (IModel)new AbstractReadOnlyModel(){

            public Object getObject() {
                return DragDropGroup.this.getJavaScriptComponentInitializationVariables();
            }
        }));
    }
}

