/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.yui.markup.html.dragdrop;

import java.util.HashMap;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.HeaderContributor;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.template.PackagedTextTemplate;
import org.wicketstuff.yui.YuiHeaderContributor;
import org.wicketstuff.yui.YuiImage;
import org.wicketstuff.yui.markup.html.dragdrop.DragDropGroup;
import org.wicketstuff.yui.markup.html.dragdrop.DragDropSettings;

public class DragDropPlayer
extends Panel {
    private static final long serialVersionUID = 1L;
    private int index;
    private YuiImage slot;
    private DragDropSettings settings;
    private String javaScriptId;

    public DragDropPlayer(final String id, final int index, YuiImage slot, DragDropSettings settings) {
        super(id);
        this.add((IBehavior)YuiHeaderContributor.forModule("dragdrop"));
        this.add((IBehavior)HeaderContributor.forJavaScript(DragDropPlayer.class, (String)"DDPlayer.js"));
        this.index = index;
        this.slot = slot;
        this.settings = settings;
        Label slotLabel = new Label("dragDropPlayerScript", (IModel)new AbstractReadOnlyModel(){
            private static final long serialVersionUID = 1L;

            public Object getObject() {
                return DragDropPlayer.this.getDragDropPlayerInitializationScript(String.valueOf(id) + index);
            }
        });
        slotLabel.setEscapeModelStrings(false);
        this.add((Component)slotLabel);
    }

    public int getIndex() {
        return this.index;
    }

    public DragDropSettings getSettings() {
        return this.settings;
    }

    public YuiImage getSlot() {
        return this.slot;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setSettings(DragDropSettings settings) {
        this.settings = settings;
    }

    public void setSlot(YuiImage slot) {
        this.slot = slot;
    }

    protected String getDragDropPlayerInitializationScript(String playerId) {
        PackagedTextTemplate template = new PackagedTextTemplate(DragDropPlayer.class, "dragdropPlayer.js");
        HashMap<String, String> variables = new HashMap<String, String>(4);
        variables.put("javaScriptId", this.javaScriptId);
        variables.put("id", playerId);
        variables.put("dragableSlot", this.settings.getDragableSlotList().getId());
        variables.put("targetSlot", this.settings.getTargetSlotList().getId());
        template.interpolate(variables);
        return template.getString();
    }

    protected void onAttach() {
        super.onAttach();
        this.javaScriptId = this.findParent(DragDropGroup.class).getMarkupId();
    }
}

