/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.yui.markup.html.selection;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.ResourceReference;
import org.wicketstuff.yui.ImageResourceInfo;
import org.wicketstuff.yui.InlineStyle;
import org.wicketstuff.yui.YuiAttribute;
import org.wicketstuff.yui.YuiImage;
import org.wicketstuff.yui.YuiProperty;
import org.wicketstuff.yui.YuiTextBox;
import org.wicketstuff.yui.markup.html.selection.Selection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectionSettings
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String background;
    private double duration;
    private String easing;
    private String event;
    private int height;
    private List<InlineStyle> inlineStyleList = new ArrayList<InlineStyle>();
    private List list;
    private int maxSelection;
    private String message;
    private int thickness;
    private int width;
    private YuiAttribute yuiAttribute;

    public static SelectionSettings getDefault(YuiAttribute yuiAttribute, String easing, double duration, String event, int maxSelection, ArrayList list) {
        SelectionSettings settings = new SelectionSettings();
        settings.setResources(yuiAttribute, easing, duration, event, maxSelection, list);
        return settings;
    }

    public static SelectionSettings getDefault(YuiAttribute yuiAttribute, String easing, double duration, String event, int maxSelection, String message, ArrayList list) {
        SelectionSettings settings = new SelectionSettings();
        settings.setResources(yuiAttribute, easing, duration, event, maxSelection, message, list);
        return settings;
    }

    public static String jsToCss(String js) {
        String css = "";
        int i = 0;
        while (i < js.length()) {
            StringBuffer aStringBuffer = new StringBuffer("");
            aStringBuffer.append(js.charAt(i));
            String aString = aStringBuffer.toString();
            css = aString.equals(aString.toUpperCase()) ? String.valueOf(css) + "-" + aString.toLowerCase() : String.valueOf(css) + aString;
            ++i;
        }
        return css;
    }

    public static String removeQuote(String js) {
        String css = "";
        int i = 0;
        while (i < js.length()) {
            StringBuffer aStringBuffer = new StringBuffer("");
            aStringBuffer.append(js.charAt(i));
            String aString = aStringBuffer.toString();
            if (!aString.equals("'")) {
                css = String.valueOf(css) + aString;
            }
            ++i;
        }
        return css;
    }

    public String getBackground() {
        return this.background;
    }

    public double getDuration() {
        return this.duration;
    }

    public String getEasing() {
        return this.easing;
    }

    public String getEvent() {
        return this.event;
    }

    public int getHeight() {
        return this.height;
    }

    public List<InlineStyle> getInlineStyleList() {
        return this.inlineStyleList;
    }

    public List getList() {
        return this.list;
    }

    public int getMaxSelection() {
        return this.maxSelection;
    }

    public String getMessage() {
        return this.message;
    }

    public int getThickness() {
        return this.thickness;
    }

    public int getWidth() {
        return this.width;
    }

    public YuiAttribute getYuiAttribute() {
        return this.yuiAttribute;
    }

    public void setBackground(String background) {
        this.background = background;
    }

    public void setDuration(double duration) {
        this.duration = duration;
    }

    public void setEasing(String easing) {
        this.easing = easing;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setImageResources(YuiAttribute yuiAttribute, List list) {
        this.setYuiAttribute(yuiAttribute);
        this.setThickness(this.thickness);
        this.setList(list);
        int i = list.size() - 1;
        while (i >= 0) {
            if (list.get(i).getClass().getSimpleName().equals("YuiImage")) {
                YuiImage aImage = (YuiImage)list.get(i);
                ResourceReference aResourceReference = new ResourceReference(Selection.class, aImage.getFileName());
                ImageResourceInfo backgroundInfo = new ImageResourceInfo(aResourceReference);
                int width = backgroundInfo.getWidth();
                int height = backgroundInfo.getHeight();
                InlineStyle aInlineStyle = new InlineStyle();
                aInlineStyle.add("background", "url(" + RequestCycle.get().urlFor(aResourceReference) + ")");
                aInlineStyle.add("width", String.valueOf(width) + "px");
                aInlineStyle.add("height", String.valueOf(height) + "px");
                Map propertyMap = yuiAttribute.getPropertyMap();
                Set keySet = propertyMap.keySet();
                for (String aKey : keySet) {
                    YuiProperty aYuiProperty = (YuiProperty)propertyMap.get(aKey);
                    aInlineStyle.add("border", "solid " + SelectionSettings.removeQuote(aYuiProperty.getFrom()));
                }
                this.inlineStyleList.add(aInlineStyle);
            } else {
                YuiTextBox aTextBox = (YuiTextBox)list.get(i);
                InlineStyle aInlineStyle = new InlineStyle();
                aInlineStyle.add("background", aTextBox.getBackground());
                aInlineStyle.add("width", String.valueOf(aTextBox.getWidth()) + "px");
                aInlineStyle.add("height", String.valueOf(aTextBox.getHeight()) + "px");
                Map propertyMap = yuiAttribute.getPropertyMap();
                Set keySet = propertyMap.keySet();
                for (String aKey : keySet) {
                    YuiProperty aYuiProperty = (YuiProperty)propertyMap.get(aKey);
                    aInlineStyle.add("border", "solid " + SelectionSettings.removeQuote(aYuiProperty.getFrom()));
                }
                this.inlineStyleList.add(aInlineStyle);
            }
            --i;
        }
    }

    public void setInlineStyleList(List<InlineStyle> inlineStyleList) {
        this.inlineStyleList = inlineStyleList;
    }

    public void setList(List list) {
        this.list = list;
    }

    public void setMaxSelection(int maxSelection) {
        this.maxSelection = maxSelection;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setResources(YuiAttribute yuiAttribute, String easing, double duration, String event, int maxSelection, ArrayList list) {
        this.setEasing("YAHOO.util.Easing." + easing);
        this.setDuration(duration);
        this.setEvent(event);
        this.setMaxSelection(maxSelection);
        this.setImageResources(yuiAttribute, list);
    }

    public void setResources(YuiAttribute yuiAttribute, String easing, double duration, String event, int maxSelection, String message, ArrayList list) {
        this.setEasing("YAHOO.util.Easing." + easing);
        this.setDuration(duration);
        this.setEvent(event);
        this.setMaxSelection(maxSelection);
        this.setMessage("'" + message + "'");
        this.setImageResources(yuiAttribute, list);
    }

    public void setThickness(int thickness) {
        this.thickness = thickness;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setYuiAttribute(YuiAttribute yuiAttribute) {
        this.yuiAttribute = yuiAttribute;
    }
}

