/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.yui.markup.html.slider;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.behavior.HeaderContributor;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.util.template.TextTemplateHeaderContributor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.yui.YuiHeaderContributor;
import org.wicketstuff.yui.markup.html.slider.SliderSettings;

public class Slider
extends Panel
implements IHeaderContributor {
    private static final long serialVersionUID = 1L;
    private static final ResourceReference CSS = new ResourceReference(Slider.class, "css/slider.css");
    private String backgroundElementId;
    private String imageElementId;
    private String javaScriptId;
    private FormComponent element;
    private float divisor;
    SliderSettings sliderSettings;
    private static final Logger log = LoggerFactory.getLogger(Slider.class);

    public Slider(String id, IModel model, FormComponent element, SliderSettings settings) {
        this(id, model, element, settings, 1.0f);
    }

    public Slider(String id, IModel model, final FormComponent element, final SliderSettings settings, float divisor) {
        super(id, model);
        this.sliderSettings = settings;
        this.add((IBehavior)YuiHeaderContributor.forModule("animation"));
        this.add((IBehavior)YuiHeaderContributor.forModule("slider"));
        this.add((IBehavior)HeaderContributor.forCss((ResourceReference)this.getCSS()));
        this.divisor = divisor;
        if (element != null) {
            element.setOutputMarkupId(true);
            this.element = element;
        }
        AbstractReadOnlyModel variablesModel = new AbstractReadOnlyModel(){
            private static final long serialVersionUID = 1L;
            private Map<String, Object> variables;

            public Object getObject() {
                if (this.variables == null) {
                    this.variables = new HashMap<String, Object>(8);
                    this.variables.put("javaScriptId", Slider.this.javaScriptId);
                    this.variables.put("backGroundElementId", Slider.this.backgroundElementId);
                    this.variables.put("imageElementId", Slider.this.imageElementId);
                    this.variables.put("leftUp", settings.getLeftUp());
                    this.variables.put("rightDown", settings.getRightDown());
                    this.variables.put("tick", settings.getTick());
                    this.variables.put("formElementId", element.getMarkupId());
                    this.variables.put("startValue", element.getModelObject());
                    this.variables.put("divisor", Float.valueOf(Slider.this.getDivisor()));
                }
                return this.variables;
            }
        };
        this.add((IBehavior)TextTemplateHeaderContributor.forJavaScript(Slider.class, (String)"init.js", (IModel)variablesModel));
        Image leftTickImg = new Image("leftTickImg", settings.getLeftTickResource());
        leftTickImg.add((IBehavior)new AttributeModifier("onclick", true, (IModel)new AbstractReadOnlyModel(){
            private static final long serialVersionUID = 1L;

            public Object getObject() {
                return String.valueOf(Slider.this.javaScriptId) + ".setValue(" + Slider.this.javaScriptId + ".getXValue() - " + settings.getTick() + ");";
            }
        }));
        this.add(leftTickImg.setVisible(settings.isShowTicks()));
        Image leftCornerImg = new Image("leftCornerImg", settings.getLeftCornerResource());
        leftCornerImg.add((IBehavior)new AttributeModifier("onclick", true, (IModel)new AbstractReadOnlyModel(){
            private static final long serialVersionUID = 1L;

            public Object getObject() {
                return String.valueOf(Slider.this.javaScriptId) + ".setValue(-" + settings.getLeftUp() + ")";
            }
        }));
        this.add((Component)leftCornerImg);
        Image rightCornerImg = new Image("rightCornerImg", settings.getRightCornerResource());
        rightCornerImg.add((IBehavior)new AttributeModifier("onclick", true, (IModel)new AbstractReadOnlyModel(){
            private static final long serialVersionUID = 1L;

            public Object getObject() {
                return String.valueOf(Slider.this.javaScriptId) + ".setValue(" + settings.getRightDown() + ")";
            }
        }));
        this.add((Component)rightCornerImg);
        Image rightTickImg = new Image("rightTickImg", settings.getRightTickResource());
        rightTickImg.add((IBehavior)new AttributeModifier("onclick", true, (IModel)new AbstractReadOnlyModel(){
            private static final long serialVersionUID = 1L;

            public Object getObject() {
                return String.valueOf(Slider.this.javaScriptId) + ".setValue(" + Slider.this.javaScriptId + ".getXValue() + " + settings.getTick() + ");";
            }
        }));
        this.add(rightTickImg.setVisible(settings.isShowTicks()));
        WebMarkupContainer backgroundElement = new WebMarkupContainer("backgroundDiv");
        backgroundElement.add((IBehavior)new AttributeModifier("id", true, (IModel)new PropertyModel((Object)this, "backgroundElementId")));
        backgroundElement.add((IBehavior)new AttributeModifier("style", true, (IModel)new Model((Serializable)((Object)settings.getBackground().getStyle()))));
        this.add((Component)backgroundElement);
        WebMarkupContainer imageElement = new WebMarkupContainer("handleDiv");
        imageElement.add((IBehavior)new AttributeModifier("id", true, (IModel)new PropertyModel((Object)this, "imageElementId")));
        imageElement.add((IBehavior)new AttributeModifier("style", true, (IModel)new Model((Serializable)((Object)settings.getHandle().getStyle()))));
        WebMarkupContainer thumbElement = new WebMarkupContainer("thumbDiv");
        thumbElement.add((IBehavior)new AttributeModifier("style", true, (IModel)new Model((Serializable)((Object)settings.getThumb().getStyle()))));
        imageElement.add((Component)thumbElement);
        backgroundElement.add((Component)imageElement);
    }

    public Slider(String id, IModel model, int leftUp, int rightDown, int tick, FormComponent element) {
        this(id, model, element, SliderSettings.getDefault(leftUp, rightDown, tick));
    }

    public final String getBackgroundElementId() {
        return this.backgroundElementId;
    }

    public final String getImageElementId() {
        return this.imageElementId;
    }

    public void renderHead(IHeaderResponse response) {
        Integer value = (Integer)this.element.getConvertedInput();
        if (value == null) {
            value = this.getSliderSettings().getStartValue();
        }
        response.renderOnLoadJavascript("init" + this.javaScriptId + "(" + value + ");");
    }

    public void updateModel() {
        log.info("updateModel");
    }

    protected void onAttach() {
        super.onAttach();
        if (this.backgroundElementId == null) {
            String id = this.getMarkupId();
            this.backgroundElementId = String.valueOf(id) + "Bg";
            this.imageElementId = String.valueOf(id) + "Img";
            this.javaScriptId = String.valueOf(this.backgroundElementId) + "JS";
        }
    }

    public float getDivisor() {
        return this.divisor;
    }

    public void setDivisor(float divisor) {
        this.divisor = divisor;
    }

    protected ResourceReference getCSS() {
        return CSS;
    }

    public SliderSettings getSliderSettings() {
        return this.sliderSettings;
    }

    public void setSliderSettings(SliderSettings sliderSettings) {
        this.sliderSettings = sliderSettings;
    }
}

