/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.yui.markup.html.sort;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.behavior.HeaderContributor;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.html.resources.CompressedResourceReference;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.template.PackagedTextTemplate;
import org.wicketstuff.yui.InlineStyle;
import org.wicketstuff.yui.YuiHeaderContributor;
import org.wicketstuff.yui.YuiImage;
import org.wicketstuff.yui.markup.html.sort.SortGroup;
import org.wicketstuff.yui.markup.html.sort.SortSettings;

public class SortBox
extends Panel {
    private static final ResourceReference DDSWAP = new CompressedResourceReference(SortBox.class, "DDSwap.js");
    private static final long serialVersionUID = 1L;
    private String javaScriptId;
    private String mode;
    private SortSettings settings;

    public SortBox(String id, final int index, YuiImage image, SortSettings settings) {
        super(id);
        this.add((IBehavior)YuiHeaderContributor.forModule("dragdrop"));
        this.add((IBehavior)HeaderContributor.forJavaScript((ResourceReference)this.getDDSWAP()));
        this.settings = settings;
        this.mode = settings.getMode();
        ImgStyle style = new ImgStyle("imgStyle");
        this.add((Component)style);
        style.add((Component)new Box("dd", index, "dd", image));
        Label sortLabel = new Label("sortScript", (IModel)new AbstractReadOnlyModel(){
            private static final long serialVersionUID = 1L;

            public Object getObject() {
                return SortBox.this.getAnimSelectInitializationScript(index);
            }
        });
        sortLabel.setEscapeModelStrings(false);
        this.add((Component)sortLabel);
    }

    protected String getAnimSelectInitializationScript(int boxId) {
        PackagedTextTemplate template = new PackagedTextTemplate(SortBox.class, "sort.js");
        HashMap<String, Object> variables = new HashMap<String, Object>(5);
        variables.put("javaScriptId", this.javaScriptId);
        variables.put("id", new Integer(boxId));
        variables.put("classId", "'dd" + boxId + "_" + this.javaScriptId + "'");
        variables.put("groupId", "'" + this.javaScriptId + "'");
        if (this.mode.equals("INTERSECT")) {
            variables.put("isIntersect", "_i");
        } else if (this.mode.equals("POINT")) {
            variables.put("isIntersect", "");
        }
        template.interpolate(variables);
        return template.getString();
    }

    protected void onAttach() {
        super.onAttach();
        this.javaScriptId = this.findParent(SortGroup.class).getMarkupId();
    }

    protected ResourceReference getDDSWAP() {
        return DDSWAP;
    }

    private final class Box
    extends FormComponent
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public Box(String id, final int count, final String name, YuiImage yuiImage) {
            super(id);
            this.add((IBehavior)new AttributeModifier("id", true, (IModel)new AbstractReadOnlyModel(){
                private static final long serialVersionUID = 1L;

                public Object getObject() {
                    return "dd" + count + "_" + SortBox.this.javaScriptId;
                }
            }));
            this.add((IBehavior)new AttributeModifier("style", true, (IModel)new AbstractReadOnlyModel(){
                private static final long serialVersionUID = 1L;

                public Object getObject() {
                    if (name.equals("dd")) {
                        List<InlineStyle> aInlineStyleList = SortBox.this.settings.getImgStyleList();
                        InlineStyle aInlineStyle = aInlineStyleList.get(count);
                        return aInlineStyle.getStyle();
                    }
                    return new String("");
                }
            }));
        }
    }

    private final class ImgStyle
    extends FormComponent
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public ImgStyle(String id) {
            super(id);
            this.add((IBehavior)new AttributeModifier("style", true, (IModel)new AbstractReadOnlyModel(){
                private static final long serialVersionUID = 1L;

                public Object getObject() {
                    return "width:" + SortBox.this.settings.getWidth() + "px; height:" + SortBox.this.settings.getHeight() + "px";
                }
            }));
        }
    }
}

