/*
 * Decompiled with CFR 0.152.
 */
package jdave.support;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reflection {
    public static Method getMethod(Class<?> specType, String name, int ... modifiers) throws NoSuchMethodException {
        return Reflection.getMethod(specType, name, null, modifiers);
    }

    public static Method getMethod(Class<?> specType, String name, Class<?>[] parameterTypes, int ... modifiers) throws NoSuchMethodException {
        for (Method method : specType.getDeclaredMethods()) {
            if (!name.equals(method.getName()) || !Reflection.hasModifiers(method, modifiers) || !Reflection.takesParameters(method, parameterTypes)) continue;
            return method;
        }
        throw new NoSuchMethodException(Modifier.toString(Reflection.combine(modifiers)) + " method '" + name + "' not found");
    }

    private static int combine(int ... modifiers) {
        if (modifiers == null) {
            return 0;
        }
        int modifier = 0;
        for (int m : modifiers) {
            modifier |= m;
        }
        return modifier;
    }

    public static boolean isVoid(Method method) {
        Class<?> returnType = method.getReturnType();
        return "void".equals(returnType.toString());
    }

    public static boolean isPublic(Method method) {
        return Reflection.hasModifier(method, 1);
    }

    public static boolean isStatic(Method method) {
        return Reflection.hasModifier(method, 8);
    }

    private static boolean hasModifiers(Method method, int ... modifiers) {
        if (modifiers == null) {
            return true;
        }
        for (int modifier : modifiers) {
            if (Reflection.hasModifier(method, modifier)) continue;
            return false;
        }
        return true;
    }

    private static boolean hasModifier(Method method, int modifier) {
        return (method.getModifiers() & modifier) != 0;
    }

    private static boolean takesParameters(Method method, Class<?> ... parameterTypes) {
        if (parameterTypes == null) {
            parameterTypes = new Class[]{};
        }
        return ((Object)Arrays.asList(method.getParameterTypes())).equals(Arrays.asList(parameterTypes));
    }
}

