/*
 * Decompiled with CFR 0.152.
 */
package jdave.contract;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import jdave.ExpectationFailedException;
import jdave.IContract;

public class CloneableContract
implements IContract {
    public void isSatisfied(Object obj) throws ExpectationFailedException {
        if (!(obj instanceof Cloneable)) {
            throw new ExpectationFailedException(obj + " does not implement Cloneable");
        }
        Method clone = this.cloneMethod(obj);
        this.invoke(obj, clone);
    }

    private void invoke(Object obj, Method clone) {
        try {
            this.invoke0(obj, clone);
        }
        catch (CloneNotSupportedException e) {
            throw new ExpectationFailedException("clone not supported in " + obj.getClass(), e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Method cloneMethod(Object obj) {
        try {
            return obj.getClass().getMethod("clone", new Class[0]);
        }
        catch (Exception e) {
            throw new ExpectationFailedException("no public clone method in " + obj.getClass());
        }
    }

    private void invoke0(Object obj, Method clone) throws CloneNotSupportedException, Exception {
        block2: {
            try {
                clone.invoke(obj, new Object[0]);
            }
            catch (InvocationTargetException e) {
                if (!(e.getCause() instanceof CloneNotSupportedException)) break block2;
                throw (CloneNotSupportedException)e.getCause();
            }
        }
    }
}

