/*
 * Decompiled with CFR 0.152.
 */
package jdave.util;

public class Diff {
    private static final int CHOP_AT = 15;
    private final String actual;
    private final String expected;

    public Diff(String actual, String expected) {
        this.actual = actual;
        this.expected = expected;
    }

    public String verbose() {
        int diffIndex = this.diffIndex();
        if (diffIndex == -1) {
            throw new IllegalArgumentException("the strings equal");
        }
        int diffStart = Math.max(0, diffIndex - 15);
        String ellipsisStart = diffIndex > 15 ? "..." : "";
        int diffEndActual = Math.min(this.length(this.actual), diffIndex + 15);
        String ellipsisEndActual = this.length(this.actual) > diffIndex + 15 ? "..." : "";
        int diffEndExpected = Math.min(this.length(this.expected), diffIndex + 15);
        String ellipsisEndExpected = this.length(this.expected) > diffIndex + 15 ? "..." : "";
        StringBuilder message = new StringBuilder();
        message.append("  Actual: ");
        message.append(ellipsisStart + this.substring(this.actual, diffStart, diffEndActual) + ellipsisEndActual);
        message.append(System.getProperty("line.separator"));
        message.append("Expected: ");
        message.append(ellipsisStart + this.substring(this.expected, diffStart, diffEndExpected) + ellipsisEndExpected);
        return message.toString();
    }

    private String substring(String s, int begin, int end) {
        return s == null ? "<<null>>" : s.substring(begin, end);
    }

    private int length(String s) {
        return s == null ? 0 : s.length();
    }

    private int diffIndex() {
        int i;
        if (this.actual == null || this.expected == null) {
            return 0;
        }
        if (this.actual.length() == 0 || this.expected.length() == 0) {
            return 0;
        }
        for (i = 0; i < this.actual.length() && i < this.expected.length(); ++i) {
            if (this.actual.charAt(i) == this.expected.charAt(i)) continue;
            return i;
        }
        if (this.actual.length() != this.expected.length()) {
            return i;
        }
        return -1;
    }

    public static Diff diff(String actual, String expected) {
        return new Diff(actual, expected);
    }
}

