/*
 * Decompiled with CFR 0.152.
 */
package jdave.runner;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import jdave.runner.LineNumberStrategy;
import net.sf.cglib.asm.Attribute;
import net.sf.cglib.asm.ClassReader;
import net.sf.cglib.asm.ClassVisitor;
import net.sf.cglib.asm.CodeVisitor;
import net.sf.cglib.asm.Label;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsmLineNumberStrategy
implements LineNumberStrategy {
    private final Map<Class<?>, LineNumberClassVisitor> cache = new HashMap();

    @Override
    public int firstLineNumber(Class<?> clazz, int defaultValue) {
        int line = this.analyze(clazz).firstClassLineNumber();
        return line < Integer.MAX_VALUE ? line : defaultValue;
    }

    @Override
    public int firstLineNumber(Method method, int defaultValue) {
        Integer line = this.analyze(method.getDeclaringClass()).firstMethodLineNumber(method);
        return line != null ? line : defaultValue;
    }

    private LineNumberClassVisitor analyze(Class<?> clazz) {
        LineNumberClassVisitor visitor = this.cache.get(clazz);
        if (visitor != null) {
            return visitor;
        }
        try {
            InputStream classAsStream = AsmLineNumberStrategy.toStream(clazz);
            ClassReader reader = new ClassReader(classAsStream);
            visitor = new LineNumberClassVisitor();
            reader.accept((ClassVisitor)visitor, false);
            classAsStream.close();
            this.cache.put(clazz, visitor);
            return visitor;
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading class: " + clazz, e);
        }
    }

    private static InputStream toStream(Class<?> clazz) {
        String name = clazz.getName();
        int i = name.lastIndexOf(46);
        if (i > 0) {
            name = name.substring(i + 1);
        }
        return clazz.getResourceAsStream(name + ".class");
    }

    private static class NullCodeVisitor
    implements CodeVisitor {
        private NullCodeVisitor() {
        }

        public void visitInsn(int opcode) {
        }

        public void visitIntInsn(int opcode, int operand) {
        }

        public void visitVarInsn(int opcode, int var) {
        }

        public void visitTypeInsn(int opcode, String desc) {
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        }

        public void visitJumpInsn(int opcode, Label label) {
        }

        public void visitLabel(Label label) {
        }

        public void visitLdcInsn(Object cst) {
        }

        public void visitIincInsn(int var, int increment) {
        }

        public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        }

        public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        }

        public void visitMultiANewArrayInsn(String desc, int dims) {
        }

        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        }

        public void visitMaxs(int maxStack, int maxLocals) {
        }

        public void visitLocalVariable(String name, String desc, Label start, Label end, int index) {
        }

        public void visitLineNumber(int line, Label start) {
        }

        public void visitAttribute(Attribute attr) {
        }
    }

    private static class NullClassVisitor
    implements ClassVisitor {
        private NullClassVisitor() {
        }

        public void visit(int version, int access, String name, String superName, String[] interfaces, String sourceFile) {
        }

        public void visitInnerClass(String name, String outerName, String innerName, int access) {
        }

        public void visitField(int access, String name, String desc, Object value, Attribute attrs) {
        }

        public CodeVisitor visitMethod(int access, String name, String desc, String[] exceptions, Attribute attrs) {
            return null;
        }

        public void visitAttribute(Attribute attr) {
        }

        public void visitEnd() {
        }
    }

    private static class LineNumberCodeVisitor
    extends NullCodeVisitor {
        private final LineNumberClassVisitor classVisitor;

        public LineNumberCodeVisitor(LineNumberClassVisitor classVisitor) {
            this.classVisitor = classVisitor;
        }

        public void visitLineNumber(int line, Label start) {
            this.classVisitor.visitLineNumber(line);
        }
    }

    private static class LineNumberClassVisitor
    extends NullClassVisitor {
        private final LineNumberCodeVisitor codeVisitor = new LineNumberCodeVisitor(this);
        private final Map<String, Integer> methodLines = new HashMap<String, Integer>();
        private int minLine = Integer.MAX_VALUE;
        private String nextMethod;

        private LineNumberClassVisitor() {
        }

        public CodeVisitor visitMethod(int access, String name, String desc, String[] exceptions, Attribute attrs) {
            this.nextMethod = name;
            return this.codeVisitor;
        }

        public void visitLineNumber(int line) {
            if (this.nextMethod != null) {
                this.minLine = Math.min(this.minLine, line);
                this.methodLines.put(this.nextMethod, line);
                this.nextMethod = null;
            }
        }

        public Integer firstMethodLineNumber(Method method) {
            return this.methodLines.get(method.getName());
        }

        public int firstClassLineNumber() {
            return this.minLine;
        }
    }
}

