/*
 * Decompiled with CFR 0.152.
 */
package jdave.runner;

import java.io.File;
import java.util.Stack;
import jdave.runner.IFileHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Scanner {
    private final String path;

    Scanner(String path) {
        this.path = path;
    }

    void forEach(String extension, IFileHandler fileHandler) {
        Stack<File> dirs = new Stack<File>();
        dirs.push(new File(this.path));
        this.forEach(extension, fileHandler, dirs);
    }

    private void forEach(String extension, IFileHandler fileHandler, Stack<File> dirs) {
        do {
            File dir = dirs.pop();
            for (File file : dir.listFiles()) {
                if (file.isDirectory()) {
                    dirs.push(file);
                    continue;
                }
                if (!file.getName().endsWith("." + extension)) continue;
                fileHandler.handle(file);
            }
        } while (!dirs.isEmpty());
    }
}

