/*
 * Decompiled with CFR 0.152.
 */
package jdave;

import jdave.Specification;
import jdave.equality.EqualsEqualityCheck;
import jdave.util.Diff;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringEqualsEqualityCheck
extends EqualsEqualityCheck {
    private final Specification<?> specification;

    public StringEqualsEqualityCheck(Specification<?> specification, String expected) {
        super(expected);
        this.specification = specification;
    }

    @Override
    public String error(Object actual) {
        if (actual == null || !actual.getClass().equals(String.class)) {
            return super.error(actual);
        }
        Diff diff = Diff.diff((String)actual, (String)this.expected);
        return "The given strings do not match:\n" + diff.verbose();
    }

    @Override
    public void verify(Object actual) {
        if (!this.matches(actual)) {
            this.specification.stringComparisonFailure().fail(this.error(actual), (String)this.expected, (String)actual);
        }
    }
}

