/*
 * Decompiled with CFR 0.152.
 */
package jdave.tools;

import jdave.tools.IDoxFormat;
import jdave.tools.Sentence;

public class XmlFormat
implements IDoxFormat {
    private StringBuilder dox = new StringBuilder();

    public void newSpec(String specName, String fqn) {
        this.dox.append("<specification name=\"" + specName + "\" fqn=\"" + fqn + "\">\n");
        this.dox.append("  <contexts>\n");
    }

    public void endSpec(String specName) {
        this.dox.append("  </contexts>\n");
        this.dox.append("</specification>\n");
    }

    public void newContext(String contextName) {
        this.dox.append("    <context name=\"" + Sentence.fromCamelCase(contextName) + "\">\n");
        this.dox.append("      <behaviors>\n");
    }

    public void endContext(String name) {
        this.dox.append("      </behaviors>\n");
        this.dox.append("    </context>\n");
    }

    public void newBehavior(String behaviorName) {
        this.dox.append("        <behavior name=\"" + Sentence.fromCamelCase(behaviorName) + "\" />\n");
    }

    public String suffix() {
        return "xml";
    }

    public String toString() {
        return this.dox.toString();
    }
}

