/*
 * Decompiled with CFR 0.152.
 */
package jdave.runner;

import java.lang.reflect.Method;
import java.util.Comparator;
import jdave.runner.LineNumberStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodLineNumberComparator
implements Comparator<Method> {
    private final LineNumberStrategy strategy = LineNumberStrategy.CURRENT_STRATEGY;

    @Override
    public int compare(Method m1, Method m2) {
        if (MethodLineNumberComparator.sameClass(m1, m2)) {
            int line1 = this.firstLineNumber(m1);
            int line2 = this.firstLineNumber(m2);
            return line1 - line2;
        }
        if (MethodLineNumberComparator.parentClass(m1, m2)) {
            return 1;
        }
        if (MethodLineNumberComparator.parentClass(m2, m1)) {
            return -1;
        }
        return MethodLineNumberComparator.alphabeticalOrder(m1, m2);
    }

    private int firstLineNumber(Method method) {
        return this.strategy.firstLineNumber(method, 0);
    }

    private static boolean sameClass(Method o1, Method o2) {
        return o1.getDeclaringClass().equals(o2.getDeclaringClass());
    }

    private static boolean parentClass(Method parent, Method child) {
        return parent.getDeclaringClass().isAssignableFrom(child.getDeclaringClass());
    }

    private static int alphabeticalOrder(Method o1, Method o2) {
        return o1.getDeclaringClass().getName().compareTo(o2.getDeclaringClass().getName());
    }
}

