/*
 * Decompiled with CFR 0.152.
 */
package jdave.runner;

import java.lang.reflect.Method;
import jdave.Specification;
import jdave.runner.Behavior;
import jdave.runner.ClassMemberSorter;
import jdave.runner.Context;
import jdave.runner.ExecutingBehavior;
import jdave.runner.ISpecVisitor;
import jdave.runner.VisitingBehavior;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpecRunner {
    public <T extends Specification<?>> void visit(Class<T> specType, ISpecVisitor callback) {
        for (Class<?> contextType : ClassMemberSorter.getDeclaredClasses(specType)) {
            Context context = new Context(specType, contextType){

                @Override
                protected Behavior newBehavior(Method method, Class<? extends Specification<?>> specType, Class<?> contextType) {
                    return new VisitingBehavior(method, contextType);
                }
            };
            this.run(callback, context);
        }
    }

    public <T extends Specification<?>> void run(Class<T> specType, ISpecVisitor callback) {
        for (Class<?> contextType : ClassMemberSorter.getDeclaredClasses(specType)) {
            Context context = new Context(specType, contextType){

                @Override
                protected Behavior newBehavior(Method method, Class<? extends Specification<?>> specType, Class<?> contextType) {
                    return new ExecutingBehavior(method, specType, contextType);
                }
            };
            this.run(callback, context);
        }
    }

    private void run(ISpecVisitor callback, Context context) {
        if (context.isContextClass()) {
            callback.onContext(context);
            context.run(callback);
            callback.afterContext(context);
        }
    }
}

