/*
 * Decompiled with CFR 0.152.
 */
package jdave.runner;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import jdave.runner.ClassLineNumberComparator;
import jdave.runner.MethodLineNumberComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassMemberSorter {
    private ClassMemberSorter() {
    }

    public static Class<?>[] getClasses(Class<?> declaringClass) {
        List<Class<?>> hierarchy = ClassMemberSorter.hierarchy(declaringClass);
        ArrayList allDeclaredClasses = new ArrayList();
        for (Class<?> clazz : hierarchy) {
            Class<?>[] classes = clazz.getDeclaredClasses();
            Arrays.sort(classes, new ClassLineNumberComparator());
            allDeclaredClasses.addAll(Arrays.asList(classes));
        }
        return allDeclaredClasses.toArray(new Class[allDeclaredClasses.size()]);
    }

    private static List<Class<?>> hierarchy(Class<?> declaringClass) {
        ArrayList hierarchy = new ArrayList();
        Class<?> root = declaringClass;
        do {
            hierarchy.add(root);
        } while ((root = root.getSuperclass()) != null && !root.equals(Object.class));
        Collections.reverse(hierarchy);
        return hierarchy;
    }

    public static Method[] getMethods(Class<?> clazz) {
        Method[] methods = clazz.getMethods();
        Arrays.sort(methods, new MethodLineNumberComparator());
        return methods;
    }
}

