/*
 * Decompiled with CFR 0.152.
 */
package jdave.runner;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import jdave.runner.ISpecIntrospection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSpecIntrospection
implements ISpecIntrospection {
    public static final String INITIALIZER_NAME = "create";
    static final String DISPOSER_NAME = "destroy";

    @Override
    public boolean isBehavior(Method method) {
        if (method.getDeclaringClass().equals(Object.class)) {
            return false;
        }
        if (method.getName().equals(INITIALIZER_NAME)) {
            return false;
        }
        if (method.getName().equals(DISPOSER_NAME)) {
            return false;
        }
        if (method.isSynthetic()) {
            return false;
        }
        return method.getParameterTypes().length <= 0;
    }

    @Override
    public boolean isContextClass(Class<?> specType, Class<?> possibleContext) {
        if (!this.isConcreteAndPublic(possibleContext)) {
            return false;
        }
        if (!this.hasBehaviors(possibleContext)) {
            return false;
        }
        return this.isInnerClass(specType, possibleContext);
    }

    private boolean hasBehaviors(Class<?> possibleContext) {
        for (Method method : possibleContext.getMethods()) {
            if (!this.isBehavior(method)) continue;
            return true;
        }
        return false;
    }

    private boolean isConcreteAndPublic(Class<?> possibleContext) {
        int mod = possibleContext.getModifiers();
        return Modifier.isPublic(mod) && !Modifier.isAbstract(mod);
    }

    private boolean isInnerClass(Class<?> specType, Class<?> possibleContext) {
        return (possibleContext.getModifiers() & 8) == 0 && possibleContext.getEnclosingClass() != null;
    }
}

