/*
 * Decompiled with CFR 0.152.
 */
package jdave.runner;

import java.io.File;
import java.io.FileNotFoundException;
import java.lang.annotation.Annotation;
import jdave.Group;
import jdave.runner.IAnnotatedSpecHandler;
import jdave.runner.IFileHandler;
import jdave.runner.Scanner;

public abstract class AnnotatedSpecScanner {
    private Scanner scanner;

    public AnnotatedSpecScanner(String path) {
        this.scanner = new Scanner(path);
    }

    public void forEach(final IAnnotatedSpecHandler annotatedSpecHandler) {
        this.scanner.forEach("class", new IFileHandler(){

            @Override
            public void handle(File file) {
                String[] groups;
                Class<?> clazz;
                try {
                    clazz = this.loadClass(file);
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException("File not found: " + file);
                }
                Group groupAnnotation = clazz.getAnnotation(Group.class);
                String[] stringArray = groups = groupAnnotation != null ? groupAnnotation.value() : new String[]{};
                if (groups.length == 0 && AnnotatedSpecScanner.this.isInDefaultGroup(clazz.getName(), clazz.getAnnotations())) {
                    groups = new String[]{"__default_group"};
                }
                if (groups.length > 0) {
                    annotatedSpecHandler.handle(clazz.getName(), groups);
                }
            }

            private Class<?> loadClass(File file) throws FileNotFoundException {
                try {
                    String cleanedPath = this.cleanup(file.getPath());
                    return Class.forName(cleanedPath);
                }
                catch (Throwable t) {
                    String path = file.getPath();
                    int idx = path.indexOf(File.separatorChar);
                    if (idx == -1) {
                        throw new FileNotFoundException();
                    }
                    path = path.substring(idx + 1);
                    return this.loadClass(new File(path));
                }
            }

            private String cleanup(String path) {
                return path.replace(".class", "").replace(File.separatorChar, '.');
            }
        });
    }

    public abstract boolean isInDefaultGroup(String var1, Annotation ... var2);
}

