/*
 * Decompiled with CFR 0.152.
 */
package jdave.runner;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import jdave.Specification;
import jdave.runner.Behavior;
import jdave.runner.ClassMemberSorter;
import jdave.runner.DefaultSpecIntrospection;
import jdave.runner.ISpecIntrospection;
import jdave.runner.ISpecVisitor;
import jdave.runner.IntrospectionStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Context {
    private final Class<? extends Specification<?>> specType;
    private final Class<?> contextType;

    public Context(Class<? extends Specification<?>> specType, Class<?> contextType) {
        this.specType = specType;
        this.contextType = contextType;
    }

    public String getName() {
        return this.contextType.getSimpleName();
    }

    protected abstract Behavior newBehavior(Method var1, Class<? extends Specification<?>> var2, Class<?> var3);

    void run(ISpecVisitor callback) {
        for (Method method : ClassMemberSorter.getMethods(this.contextType)) {
            if (!this.isBehavior(method)) continue;
            callback.onBehavior(this.newBehavior(method, this.specType, this.contextType));
        }
    }

    private boolean isBehavior(Method method) {
        return this.newIntrospection().isBehavior(method);
    }

    public boolean isContextClass() {
        return this.newIntrospection().isContextClass(this.specType, this.contextType);
    }

    private ISpecIntrospection newIntrospection() {
        try {
            Class<Specification<?>> clazz = this.specType;
            do {
                Collection<Class<?>> types = this.typesOf(clazz);
                for (Class<?> type : types) {
                    if (!this.hasStrategy(type)) continue;
                    return type.getAnnotation(IntrospectionStrategy.class).value().newInstance();
                }
            } while ((clazz = clazz.getSuperclass()) != null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new DefaultSpecIntrospection();
    }

    private Collection<Class<?>> typesOf(Class<?> clazz) {
        Class<?>[] interfaces;
        ArrayList types = new ArrayList();
        types.add(clazz);
        for (Class<?> anInterface : interfaces = clazz.getInterfaces()) {
            types.add(anInterface);
        }
        return types;
    }

    boolean hasStrategy(Class<?> type) {
        return type.isAnnotationPresent(IntrospectionStrategy.class);
    }
}

