/*
 * Decompiled with CFR 0.152.
 */
package jdave.runner;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import jdave.runner.LineNumberStrategy;
import net.sf.cglib.asm.AnnotationVisitor;
import net.sf.cglib.asm.Attribute;
import net.sf.cglib.asm.ClassReader;
import net.sf.cglib.asm.ClassVisitor;
import net.sf.cglib.asm.FieldVisitor;
import net.sf.cglib.asm.Label;
import net.sf.cglib.asm.MethodVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsmLineNumberStrategy
implements LineNumberStrategy {
    private final Map<Class<?>, LineNumberClassVisitor> cache = new HashMap();

    @Override
    public int firstLineNumber(Class<?> clazz, int defaultValue) {
        int line = this.analyze(clazz).firstClassLineNumber();
        return line < Integer.MAX_VALUE ? line : defaultValue;
    }

    @Override
    public int firstLineNumber(Method method, int defaultValue) {
        Integer line = this.analyze(method.getDeclaringClass()).firstMethodLineNumber(method);
        return line != null ? line : defaultValue;
    }

    private LineNumberClassVisitor analyze(Class<?> clazz) {
        LineNumberClassVisitor visitor = this.cache.get(clazz);
        if (visitor != null) {
            return visitor;
        }
        try {
            InputStream classAsStream = AsmLineNumberStrategy.toStream(clazz);
            ClassReader reader = new ClassReader(classAsStream);
            visitor = new LineNumberClassVisitor();
            reader.accept((ClassVisitor)visitor, 0);
            classAsStream.close();
            this.cache.put(clazz, visitor);
            return visitor;
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading class: " + clazz, e);
        }
    }

    private static InputStream toStream(Class<?> clazz) {
        String name = clazz.getName();
        int i = name.lastIndexOf(46);
        if (i > 0) {
            name = name.substring(i + 1);
        }
        return clazz.getResourceAsStream(name + ".class");
    }

    private static class NullCodeVisitor
    implements MethodVisitor {
        private NullCodeVisitor() {
        }

        public void visitInsn(int opcode) {
        }

        public void visitIntInsn(int opcode, int operand) {
        }

        public void visitVarInsn(int opcode, int var) {
        }

        public void visitTypeInsn(int opcode, String desc) {
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        }

        public void visitJumpInsn(int opcode, Label label) {
        }

        public void visitLabel(Label label) {
        }

        public void visitLdcInsn(Object cst) {
        }

        public void visitIincInsn(int var, int increment) {
        }

        public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        }

        public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        }

        public void visitMultiANewArrayInsn(String desc, int dims) {
        }

        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        }

        public void visitMaxs(int maxStack, int maxLocals) {
        }

        public void visitLineNumber(int line, Label start) {
        }

        public void visitAttribute(Attribute attr) {
        }

        public AnnotationVisitor visitAnnotation(String arg0, boolean arg1) {
            return null;
        }

        public AnnotationVisitor visitAnnotationDefault() {
            return null;
        }

        public void visitCode() {
        }

        public void visitEnd() {
        }

        public void visitFrame(int arg0, int arg1, Object[] arg2, int arg3, Object[] arg4) {
        }

        public void visitLocalVariable(String arg0, String arg1, String arg2, Label arg3, Label arg4, int arg5) {
        }

        public AnnotationVisitor visitParameterAnnotation(int arg0, String arg1, boolean arg2) {
            return null;
        }
    }

    private static class NullClassVisitor
    implements ClassVisitor {
        private NullClassVisitor() {
        }

        public void visitInnerClass(String name, String outerName, String innerName, int access) {
        }

        public void visitAttribute(Attribute attr) {
        }

        public void visitEnd() {
        }

        public void visit(int arg0, int arg1, String arg2, String arg3, String arg4, String[] arg5) {
        }

        public AnnotationVisitor visitAnnotation(String arg0, boolean arg1) {
            return null;
        }

        public FieldVisitor visitField(int arg0, String arg1, String arg2, String arg3, Object arg4) {
            return null;
        }

        public MethodVisitor visitMethod(int arg0, String arg1, String arg2, String arg3, String[] arg4) {
            return null;
        }

        public void visitOuterClass(String arg0, String arg1, String arg2) {
        }

        public void visitSource(String arg0, String arg1) {
        }
    }

    private static class LineNumberCodeVisitor
    extends NullCodeVisitor {
        private final LineNumberClassVisitor classVisitor;

        public LineNumberCodeVisitor(LineNumberClassVisitor classVisitor) {
            this.classVisitor = classVisitor;
        }

        public void visitLineNumber(int line, Label start) {
            this.classVisitor.visitLineNumber(line);
        }
    }

    private static class LineNumberClassVisitor
    extends NullClassVisitor {
        private final LineNumberCodeVisitor codeVisitor = new LineNumberCodeVisitor(this);
        private final Map<String, Integer> methodLines = new HashMap<String, Integer>();
        private int minLine = Integer.MAX_VALUE;
        private String nextMethod;

        private LineNumberClassVisitor() {
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if ((access & 1) == 0) {
                return null;
            }
            this.nextMethod = name;
            return this.codeVisitor;
        }

        public void visitLineNumber(int line) {
            if (this.nextMethod != null) {
                this.minLine = Math.min(this.minLine, line);
                this.methodLines.put(this.nextMethod, line);
                this.nextMethod = null;
            }
        }

        public Integer firstMethodLineNumber(Method method) {
            return this.methodLines.get(method.getName());
        }

        public int firstClassLineNumber() {
            return this.minLine;
        }
    }
}

