/*
 * Decompiled with CFR 0.152.
 */
package jdave;

import jdave.ExpectedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpectedExceptionWithMessage<T>
extends ExpectedException<T> {
    protected final String message;

    public ExpectedExceptionWithMessage(Class<? extends T> type, String message) {
        super(type);
        this.message = message;
    }

    @Override
    public boolean matches(Throwable t) {
        return this.matchesType(t.getClass()) && this.matchesMessage(t.getMessage());
    }

    @Override
    public String error(Throwable t) {
        if (!this.matchesType(t.getClass())) {
            return "The specified block should throw " + this.expected.getName() + " but " + t.getClass().getName() + " was thrown.";
        }
        if (!this.matchesMessage(t.getMessage())) {
            return "Expected the exception message to be \"" + this.message + "\", but was: \"" + t.getMessage() + "\".";
        }
        throw new IllegalStateException();
    }

    private boolean matchesMessage(String message) {
        if (message == null && this.message == null) {
            return true;
        }
        if (message == null) {
            return false;
        }
        if (this.message == null) {
            return false;
        }
        return message.equals(this.message);
    }
}

