/*
 * Decompiled with CFR 0.152.
 */
package jdave.runner;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import jdave.Specification;
import jdave.runner.Behavior;
import jdave.runner.ClassMemberSorter;
import jdave.runner.Context;
import jdave.runner.ExecutingBehavior;
import jdave.runner.ISpecVisitor;
import jdave.runner.VisitingBehavior;
import jdave.support.Reflection;
import org.junit.Ignore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpecRunner {
    public <T extends Specification<?>> void visit(Class<T> specType, ISpecVisitor callback) {
        for (Class<?> contextType : this.getContextsOf(specType)) {
            Context context = new Context(specType, contextType){

                @Override
                protected Behavior newBehavior(Method method, Class<? extends Specification<?>> specType, Class<?> contextType) {
                    return new VisitingBehavior(method, contextType);
                }
            };
            this.run(callback, context);
        }
    }

    public <T extends Specification<?>> void run(Class<T> specType, ISpecVisitor callback) {
        this.runOnceBefores(specType);
        this.runContexts(specType, callback);
        this.runOnceAfters(specType);
    }

    private <T extends Specification<?>> void runOnceBefores(Class<T> specType) {
        this.runPublicStaticVoidMethodNamed("onceBefore", specType);
    }

    private <T extends Specification<?>> void runOnceAfters(Class<T> specType) {
        this.runPublicStaticVoidMethodNamed("onceAfter", specType);
    }

    private <T> void runPublicStaticVoidMethodNamed(String name, Class<T> specType) {
        try {
            Method method = Reflection.getMethod(specType, name, 1, 8);
            try {
                method.invoke(null, new Object[0]);
            }
            catch (Exception e) {}
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    private <T extends Specification<?>> void runContexts(Class<T> specType, ISpecVisitor callback) {
        for (Class<?> contextType : this.getContextsOf(specType)) {
            Context context = new Context(specType, contextType){

                @Override
                protected Behavior newBehavior(Method method, Class<? extends Specification<?>> specType, Class<?> contextType) {
                    return new ExecutingBehavior(method, specType, contextType);
                }
            };
            this.run(callback, context);
        }
    }

    private void run(ISpecVisitor callback, Context context) {
        if (context.isContextClass()) {
            callback.onContext(context);
            context.run(callback);
            callback.afterContext(context);
        }
    }

    private <T> Class<?>[] getContextsOf(Class<T> specType) {
        ArrayList classes = new ArrayList();
        for (Class<?> member : ClassMemberSorter.getClasses(specType)) {
            if (!this.qualifiesAsContext(member)) continue;
            classes.add(member);
        }
        return classes.toArray(new Class[classes.size()]);
    }

    private boolean qualifiesAsContext(Class<?> clazz) {
        return !this.annotationIsPresent(clazz, Ignore.class);
    }

    private boolean annotationIsPresent(Class<?> clazz, Class<? extends Annotation> annotationType) {
        for (Annotation annotation : clazz.getAnnotations()) {
            if (!annotation.annotationType().equals(annotationType)) continue;
            return true;
        }
        return false;
    }
}

