/*
 * Decompiled with CFR 0.152.
 */
package jdave.tools;

public class Sentence {
    private final String sentence;

    private Sentence(String sentence) {
        this.sentence = sentence;
    }

    public static Sentence fromCamelCase(String s) {
        StringBuilder sentence = new StringBuilder();
        boolean inNumber = false;
        for (int pos = 0; pos < s.length(); ++pos) {
            char ch = s.charAt(pos);
            if (Character.isDigit(ch)) {
                if (!inNumber) {
                    sentence.append(" ");
                }
                sentence.append(ch);
                inNumber = true;
                continue;
            }
            if (Sentence.isUpperCase(pos, ch) || inNumber) {
                sentence.append(" ");
                sentence.append(Character.toLowerCase(ch));
            } else {
                sentence.append(ch);
            }
            inNumber = false;
        }
        return new Sentence(sentence.toString().trim());
    }

    private static boolean isUpperCase(int pos, char ch) {
        return pos > 0 && Character.isUpperCase(ch);
    }

    public String toString() {
        return this.sentence;
    }
}

