/*
 * Decompiled with CFR 0.152.
 */
package jdave;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jdave.Block;
import jdave.DefaultContextObjectFactory;
import jdave.Each;
import jdave.ExactExpectedException;
import jdave.ExactExpectedExceptionWithMessage;
import jdave.ExpectationFailedException;
import jdave.ExpectationFailedStringComparisonFailure;
import jdave.ExpectedException;
import jdave.ExpectedExceptionWithMessage;
import jdave.ExpectedNoThrow;
import jdave.IContainment;
import jdave.IContextObjectFactory;
import jdave.IContract;
import jdave.IEqualityCheck;
import jdave.ILifecycleListener;
import jdave.IStringComparisonFailure;
import jdave.Not;
import jdave.StringEqualsEqualityCheck;
import jdave.Where;
import jdave.containment.MapContainment;
import jdave.equality.DeltaEqualityCheck;
import jdave.equality.EqualsEqualityCheck;
import jdave.equality.LongEqualsEqualityCheck;
import jdave.equality.NotEqualsEqualityCheck;
import jdave.mock.MockSupport;
import jdave.util.Collections;
import jdave.util.Primitives;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Specification<T>
extends MockSupport {
    protected Specification<T> should = this;
    protected Specification<T> does = this;
    protected Specification<T> must = this;
    private boolean actualState = true;
    public T be;
    public T context;
    private final List<ILifecycleListener> listeners = new ArrayList<ILifecycleListener>();
    private IContextObjectFactory<T> contextObjectFactory = new DefaultContextObjectFactory();
    private static IStringComparisonFailure stringComparisonFailure = new ExpectationFailedStringComparisonFailure();

    public Not<T> not() {
        this.actualState = false;
        return new Not(this);
    }

    public void specify(boolean expected) {
        this.specify0(null, expected);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void specify0(T actual, boolean expected) {
        try {
            if (expected != this.actualState) {
                throw new ExpectationFailedException("Expected: true, but was: false" + (actual != null ? " (actual was '" + actual + "')" : ""));
            }
        }
        finally {
            this.resetActualState();
        }
    }

    public void specify(T actual, boolean expected) {
        this.specify0(actual, expected);
    }

    public void specify(T actual, Boolean expected) {
        this.specify0(actual, expected);
    }

    private void resetActualState() {
        this.actualState = true;
    }

    public <E> void specify(Iterator<E> actual, IContainment<E> containment) {
        this.specify(Collections.list(actual), containment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E> void specify(Collection<E> actual, IContainment<E> containment) {
        try {
            if (!containment.matches(actual)) {
                throw new ExpectationFailedException(containment.error(actual));
            }
        }
        finally {
            this.resetActualState();
        }
    }

    public <E> void specify(Object[] actual, IContainment<E> containment) {
        this.specify((Object)Arrays.asList(actual), (Matcher<?>)containment);
    }

    public <E> void specify(boolean[] actual, IContainment<E> containment) {
        this.specify((Object)Primitives.asList(actual), (Matcher<?>)containment);
    }

    public <E> void specify(byte[] actual, IContainment<E> containment) {
        this.specify((Object)Primitives.asList(actual), (Matcher<?>)containment);
    }

    public <E> void specify(char[] actual, IContainment<E> containment) {
        this.specify((Object)Primitives.asList(actual), (Matcher<?>)containment);
    }

    public <E> void specify(double[] actual, IContainment<E> containment) {
        this.specify((Object)Primitives.asList(actual), (Matcher<?>)containment);
    }

    public <E> void specify(float[] actual, IContainment<E> containment) {
        this.specify((Object)Primitives.asList(actual), (Matcher<?>)containment);
    }

    public <E> void specify(int[] actual, IContainment<E> containment) {
        this.specify((Object)Primitives.asList(actual), (Matcher<?>)containment);
    }

    public <E> void specify(long[] actual, IContainment<E> containment) {
        this.specify((Object)Primitives.asList(actual), (Matcher<?>)containment);
    }

    public <E> void specify(short[] actual, IContainment<E> containment) {
        this.specify((Object)Primitives.asList(actual), (Matcher<?>)containment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void specify(Object actual, Object expected) {
        EqualsEqualityCheck equalityCheck = new EqualsEqualityCheck(expected);
        try {
            if (!equalityCheck.matches(actual)) {
                throw new ExpectationFailedException(equalityCheck.error(actual));
            }
        }
        finally {
            this.resetActualState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void specify(Object actual, IEqualityCheck equalityCheck) {
        try {
            equalityCheck.verify(actual);
        }
        finally {
            this.resetActualState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void specify(Object actual, Matcher<?> matcher) {
        try {
            if (!matcher.matches(actual)) {
                throw new ExpectationFailedException(actual + " " + StringDescription.toString(matcher));
            }
        }
        finally {
            this.resetActualState();
        }
    }

    public <E> void specify(Collection<E> actual, Where<E> where) {
        this.specify(actual.iterator(), where);
    }

    public <E> void specify(Iterable<E> actual, Where<E> where) {
        this.specify(actual.iterator(), where);
    }

    public <E> void specify(Object[] actual, Where<E> where) {
        this.specify((Object)Arrays.asList(actual), (Object)where);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E> void specify(Iterator<E> actual, Where<E> where) {
        try {
            int index = 0;
            while (actual.hasNext()) {
                where.match(actual.next(), index);
                ++index;
            }
            where.areAllMatchersUsed(index);
        }
        finally {
            this.resetActualState();
        }
    }

    public <E> Where<E> where(Each<E> each) {
        return new Where<E>(each);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V extends Throwable> void specify(Block block, ExpectedException<V> expectation) {
        try {
            this.specifyThrow(block, expectation);
        }
        finally {
            this.resetActualState();
        }
    }

    private void specifyThrow(Block block, ExpectedException<? extends Throwable> expectation) {
        try {
            block.run();
        }
        catch (Throwable t) {
            if (!expectation.matches(t)) {
                throw new ExpectationFailedException(expectation.error(t), t);
            }
            return;
        }
        throw new ExpectationFailedException(expectation.notThrown());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V extends Throwable> void specify(Block block, ExpectedNoThrow<V> expectation) throws Throwable {
        try {
            this.specifyNoThrow(block, expectation);
        }
        finally {
            this.resetActualState();
        }
    }

    private void specifyNoThrow(Block block, ExpectedNoThrow<? extends Throwable> expectation) throws Throwable {
        try {
            block.run();
        }
        catch (Throwable t) {
            if (!expectation.matches(t)) {
                throw new ExpectationFailedException(expectation.error(t), t);
            }
            throw t;
        }
    }

    public void specify(Object obj, IContract contract) {
        contract.isSatisfied(obj);
    }

    public IEqualityCheck equal(long expected) {
        return new LongEqualsEqualityCheck(expected);
    }

    public IEqualityCheck equal(String obj) {
        if (obj == null) {
            return new EqualsEqualityCheck(obj);
        }
        return new StringEqualsEqualityCheck(this, obj);
    }

    public IEqualityCheck equal(Object obj) {
        return new EqualsEqualityCheck(obj);
    }

    public IEqualityCheck equal(Number expectedNumber, double delta) {
        return new DeltaEqualityCheck(expectedNumber, delta);
    }

    public <E extends Throwable> ExpectedException<E> raise(Class<E> expected) {
        return new ExpectedException<E>(expected);
    }

    public <E extends Throwable> ExpectedException<E> raise(Class<E> expectedType, String expectedMessage) {
        return new ExpectedExceptionWithMessage<E>(expectedType, expectedMessage);
    }

    public <E extends Throwable> ExpectedException<E> raiseExactly(Class<E> expected) {
        return new ExactExpectedException<E>(expected);
    }

    public <E extends Throwable> ExpectedException<E> raiseExactly(Class<E> expected, String expectedMessage) {
        return new ExactExpectedExceptionWithMessage<E>(expected, expectedMessage);
    }

    public IContract satisfies(IContract contract) {
        return contract;
    }

    public void create() throws Exception {
    }

    public void destroy() throws Exception {
    }

    public boolean needsThreadLocalIsolation() {
        return false;
    }

    protected void setContextObjectFactory(IContextObjectFactory<T> contextObjectFactory) {
        this.contextObjectFactory = contextObjectFactory;
    }

    public IContextObjectFactory<T> getContextObjectFactory() {
        return this.contextObjectFactory;
    }

    protected void addListener(ILifecycleListener listener) {
        this.listeners.add(listener);
    }

    public void fireAfterContextInstantiation(Object contextInstance) {
        for (ILifecycleListener listener : this.listeners) {
            listener.afterContextInstantiation(contextInstance);
        }
    }

    public void fireAfterContextCreation(Object contextInstance, Object createdContext) {
        for (ILifecycleListener listener : this.listeners) {
            listener.afterContextCreation(contextInstance, createdContext);
        }
    }

    public void fireAfterContextDestroy(Object contextInstance) {
        for (ILifecycleListener listener : this.listeners) {
            listener.afterContextDestroy(contextInstance);
        }
    }

    public IEqualityCheck isNotNull() {
        return new NotEqualsEqualityCheck(null){

            public String error(Object actual) {
                return "Expected a non-null value";
            }
        };
    }

    public static void setStringComparisonFailure(IStringComparisonFailure failure) {
        stringComparisonFailure = failure;
    }

    IStringComparisonFailure stringComparisonFailure() {
        return stringComparisonFailure;
    }

    public MapContainment maps(Object ... keys) {
        return new MapContainment(keys);
    }

    public void specify(Map<?, ?> actual, MapContainment containment) {
        containment.verify(actual);
    }

    public void fail(String message) {
        throw new ExpectationFailedException(message);
    }
}

