/*
 * Decompiled with CFR 0.152.
 */
package jdave;

public class ExpectedException<T> {
    protected final Class<? extends T> expected;

    public ExpectedException(Class<? extends T> expected) {
        this.expected = expected;
    }

    public boolean matches(Throwable t) {
        return this.matchesType(t.getClass());
    }

    public String error(Throwable t) {
        if (!this.matchesType(t.getClass())) {
            return "The specified block should throw " + this.expected.getName() + " but " + t.getClass().getName() + " was thrown.";
        }
        throw new IllegalStateException();
    }

    protected boolean matchesType(Class<? extends Throwable> actual) {
        return this.expected.isAssignableFrom(actual);
    }

    public String notThrown() {
        return "The specified block should throw " + this.expected.getName() + " but nothing was thrown.";
    }
}

