/*
 * Decompiled with CFR 0.152.
 */
package jdave.injection;

import java.util.ArrayList;
import java.util.List;
import jdave.injection.Field;
import jdave.injection.IFieldInjector;

public class InjectionSupport {
    private final int modifiers;

    public InjectionSupport() {
        this.modifiers = 7;
    }

    public InjectionSupport(int modifiers) {
        this.modifiers = modifiers;
    }

    public void inject(Object object, IFieldInjector injector) {
        Class<?> type = object.getClass();
        do {
            List<Field> fields = this.fieldsFor(object, type);
            for (Field field : fields) {
                injector.inject(field);
            }
        } while ((type = type.getSuperclass()) != null);
    }

    private List<Field> fieldsFor(Object object, Class<?> type) {
        java.lang.reflect.Field[] declaredFields;
        ArrayList<Field> fields = new ArrayList<Field>();
        for (java.lang.reflect.Field field : declaredFields = type.getDeclaredFields()) {
            if ((field.getModifiers() & this.modifiers) == 0) continue;
            fields.add(new Field(object, field));
        }
        return fields;
    }
}

