/*
 * Decompiled with CFR 0.152.
 */
package jdave.runner;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import jdave.runner.ClassLineNumberComparator;
import jdave.runner.MethodLineNumberComparator;

public final class ClassMemberSorter {
    private ClassMemberSorter() {
    }

    public static Class<?>[] getClasses(Class<?> declaringClass) {
        ArrayList allDeclaredClasses = new ArrayList();
        for (Class<?> clazz : ClassMemberSorter.inheritanceHierarchyOf(declaringClass)) {
            Class<?>[] classes = ClassMemberSorter.contextClassesDeclaredIn(clazz);
            Arrays.sort(classes, new ClassLineNumberComparator());
            allDeclaredClasses.addAll(Arrays.asList(classes));
        }
        return allDeclaredClasses.toArray(new Class[allDeclaredClasses.size()]);
    }

    private static Class<?>[] contextClassesDeclaredIn(Class<?> clazz) {
        return clazz.getDeclaredClasses();
    }

    private static List<Class<?>> inheritanceHierarchyOf(Class<?> declaringClass) {
        ArrayList hierarchy = new ArrayList();
        Class<?> root = declaringClass;
        do {
            hierarchy.add(root);
        } while ((root = root.getSuperclass()) != null && !root.equals(Object.class));
        Collections.reverse(hierarchy);
        return hierarchy;
    }

    public static Method[] getMethods(Class<?> clazz) {
        Method[] methods = clazz.getMethods();
        Arrays.sort(methods, new MethodLineNumberComparator());
        return methods;
    }
}

