/*
 * Decompiled with CFR 0.152.
 */
package jdave.runner;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import jdave.ExpectationFailedException;
import jdave.Specification;
import jdave.runner.Behavior;
import jdave.runner.IBehaviorResults;
import jdave.util.Fields;

public class ExecutingBehavior
extends Behavior {
    private final Class<?> contextType;
    private final Class<? extends Specification<?>> specType;
    private Object context;

    public ExecutingBehavior(Method method, Class<? extends Specification<?>> specType, Class<?> contextType) {
        super(contextType, method);
        this.specType = specType;
        this.contextType = contextType;
    }

    @Override
    public void run(IBehaviorResults results) {
        try {
            Specification<?> spec = this.newSpecification();
            if (spec.needsThreadLocalIsolation()) {
                this.runInNewThread(results, spec);
            } else {
                this.runInCurrentThread(results, spec);
            }
        }
        catch (Throwable e) {
            results.error(this.method, e);
        }
    }

    private void runInCurrentThread(IBehaviorResults results, Specification<?> spec) {
        this.runSpec(results, spec);
    }

    private void runInNewThread(final IBehaviorResults results, final Specification<?> spec) {
        ExecutorService executor = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r);
            }
        });
        executor.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ExecutingBehavior.this.runSpec(results, spec);
                return null;
            }
        });
        executor.shutdown();
        try {
            executor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runSpec(IBehaviorResults results, Specification<?> spec) {
        boolean error = false;
        try {
            spec.create();
            this.context = this.newContext(spec);
            this.method.invoke(this.context, new Object[0]);
            spec.verifyMocks();
            results.expected(this.method);
        }
        catch (InvocationTargetException e) {
            error = true;
            if (e.getCause().getClass().equals(ExpectationFailedException.class)) {
                results.unexpected(this.method, (ExpectationFailedException)e.getCause());
            } else {
                results.error(this.method, e.getCause());
            }
        }
        catch (ExpectationFailedException e) {
            error = true;
            results.unexpected(this.method, e);
        }
        catch (Throwable t) {
            error = true;
            results.error(this.method, t);
        }
        finally {
            block22: {
                try {
                    this.destroy(spec);
                }
                catch (Throwable e) {
                    if (error) break block22;
                    throw new RuntimeException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroy(Specification<?> spec) throws Exception {
        try {
            this.destroyContext();
        }
        finally {
            try {
                spec.fireAfterContextDestroy(this.context);
            }
            finally {
                spec.destroy();
            }
        }
    }

    protected Specification<?> newSpecification() {
        try {
            return this.specType.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Object newContext(Specification<?> spec) throws Exception {
        Object context = this.newContextInstance(spec);
        spec.fireAfterContextInstantiation(context);
        Object contextObject = spec.getContextObjectFactory().newContextObject(context);
        Fields.set(spec, "be", contextObject);
        Fields.set(spec, "context", contextObject);
        spec.fireAfterContextCreation(context, contextObject);
        return context;
    }

    protected void destroyContext() throws Exception {
        if (this.context != null) {
            this.invokeDisposer(this.context);
        }
    }

    private Object newContextInstance(Specification<?> spec) {
        try {
            Constructor<?> constructor = this.contextType.getDeclaredConstructor(this.contextType.getEnclosingClass());
            return constructor.newInstance(spec);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void invokeDisposer(Object context) throws Exception {
        try {
            Method method = context.getClass().getMethod("destroy", new Class[0]);
            method.invoke(context, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }
}

