/*
 * Decompiled with CFR 0.152.
 */
package jdave.runner;

import java.util.Collection;
import jdave.runner.Groups;
import jdave.support.Assert;

public class Resolution {
    private final Groups groups;

    public Resolution(Groups groups) {
        Assert.notNull(groups, "must include @Groups annotation");
        this.groups = groups;
    }

    public boolean includes(Collection<String> groupsToCheck) {
        for (String groupToInclude : this.groups.include()) {
            if (!this.includes(groupsToCheck, groupToInclude)) continue;
            return !this.excludes(groupsToCheck);
        }
        return false;
    }

    private boolean excludes(Collection<String> groupsToCheck) {
        for (String groupToExclude : this.groups.exclude()) {
            if (groupToExclude.equals("__all_groups")) {
                return true;
            }
            if (!groupsToCheck.contains(groupToExclude)) continue;
            return true;
        }
        return false;
    }

    private boolean includes(Collection<String> groupsToCheck, String groupToInclude) {
        if (groupToInclude.equals("__all_groups")) {
            return true;
        }
        return groupsToCheck.contains(groupToInclude);
    }
}

