/*
 * Decompiled with CFR 0.152.
 */
package jdave.runner;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Stack;
import jdave.runner.IFileHandler;

class Scanner {
    private final URI path;

    Scanner(String path) {
        try {
            this.path = path.startsWith("/") ? new URI("file://" + path.replace(" ", "%20")) : new URI(path.replace(" ", "%20"));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    void forEach(String extension, IFileHandler fileHandler) {
        Stack<File> dirs = new Stack<File>();
        dirs.push(new File(this.path.getPath()));
        this.forEach(extension, fileHandler, dirs);
    }

    private void forEach(String extension, IFileHandler fileHandler, Stack<File> dirs) {
        do {
            File dir = dirs.pop();
            for (File file : dir.listFiles()) {
                if (file.isDirectory()) {
                    dirs.push(file);
                    continue;
                }
                if (!file.getName().endsWith("." + extension)) continue;
                fileHandler.handle(file);
            }
        } while (!dirs.isEmpty());
    }
}

