/*
 * Decompiled with CFR 0.152.
 */
package jdave.tools;

import java.io.File;
import java.io.IOException;
import jdave.support.IO;
import jdave.tools.DoxStoreException;
import jdave.tools.IDoxStore;

public class FileStore
implements IDoxStore {
    private String dir;

    public FileStore(String dir) {
        this.dir = dir;
    }

    @Override
    public void store(String doxName, String suffix, String content) {
        try {
            File directory = new File(this.dir);
            if (!directory.exists()) {
                directory.mkdirs();
            }
            File file = this.newFile(directory, doxName + "." + suffix);
            IO.write(file, content);
        }
        catch (IOException e) {
            throw new DoxStoreException(e);
        }
    }

    protected File newFile(File dir, String name) throws IOException {
        return new File(dir, name);
    }
}

